<?php
require_once('includes/definition.php');

class subscribers_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de subscriber.
*
* Consulta de subscriber registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de subscriber registrados
* @param Int $datos id del usuario
*/
public function query_subscribers($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_subscriber as id,b.identification_subscriber as identificador,b.name_subscriber as name,b.email_subscriber as email,b.surname_subscriber as apellido,b.id_country as pais,b.agent_subscriber as agente,s.status_name as status,s.status_color as color,b.date_start as salida,b.date_expiration as llegada FROM subscribers as b INNER JOIN status as s ON (b.id_status=s.id_status) ");

    }else{
        $consulta=$this->db->query("SELECT b.id_subscriber as id,b.name_subscriber as name,b.email_subscriber as email,b.email_emergency as email_e,b.surname_subscriber as apellido,b.sex_subscriber as sexo,b.identification_subscriber as identificador,b.id_country as pais,b.phones_subscriber as tlf,b.date_birth as fecha_n,b.type_agent as type_a,b.agent_subscriber as agente,b.id_status as status FROM subscribers as b WHERE b.id_subscriber='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Detalle de subscriber.
*
* Detalle de subscriber registrados en caso de recibir parametro not null la Detalle se hace por id*
*
* @return Array de subscriber registrados
* @param Int $datos id del usuario
*/
public function details_subscribers($datos){
    $consulta=$this->db->query("SELECT b.id_subscriber as id,b.name_subscriber as name,b.email_subscriber as email,b.surname_subscriber as apellido,b.email_emergency as email_e,b.sex_subscriber as sexo,b.type_agent as type_a,b.id_country as pais,b.phones_subscriber as tlf,b.date_birth as fecha_n,b.agent_subscriber as agente,s.status_name as status,s.status_color as color,b.identification_subscriber as identificador FROM subscribers as b INNER JOIN status as s ON (b.id_status=s.id_status) WHERE b.id_subscriber='$datos' ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Validar de categorias.
*
* Validar de categorias registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de categorias registrados
* @param Int $datos id del usuario
*/
public function check_lists($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
        $consulta=$this->db->query("SELECT b.id_list as id FROM subscriber_lists as b WHERE b.id_subscriber='$datos' ");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas['id'];
        }
    }else{
        $consulta=$this->db->query("SELECT b.id_list as id, c.name_list as name FROM subscriber_lists as b INNER JOIN lists as c ON (b.id_list=c.id_list) WHERE b.id_subscriber='$datos' ");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas;
        }
    }
    return $query;
}
/**
* Consulta de etiqueta.
*
* Consulta de etiqueta registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de etiqueta registrados
* @param Int $datos id del usuario
*/
public function query_lists($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_list as id,b.name_list as name FROM lists as b WHERE b.id_status=1 ");
    }else{
        $consulta=$this->db->query("SELECT b.id_list as id,b.name_list as name FROM lists as b WHERE b.id_status=1 AND b.id_list='$datos'");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Validar de fecha.
*
*
* @return Boolean
*/
function validateDate($date, $format = 'Y-m-d')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}
/**
* Consulta de paises.
*
* Consulta de paises registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de paises registrados
* @param Int $datos id del usuario
*/
public function query_countries($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_country as id,b.name_country as name FROM countries as b WHERE b.id_status=1 ");
    }else{
        $consulta=$this->db->query("SELECT b.id_country as id,b.name_country as name FROM countries as b WHERE b.id_status=1 AND b.name_country='$datos'");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
*/
public function register_subscriber($identificacion,$name,$apellido,$email,$email_e,$type_a,$agente,$tlf,$fecha_nac,$sexo,$pais,$listas,$status,$user){
    $date=date('Y-m-d H:i:s');
    $fecha_nac=(empty($fecha_nac))? "NULL" : "'$fecha_nac'";
    $insert=$this->db->query("INSERT INTO subscribers(identification_subscriber,email_subscriber,name_subscriber,surname_subscriber,sex_subscriber,phones_subscriber,date_birth,email_emergency,type_agent,agent_subscriber,id_country,id_user,create_date) VALUES ('$identificacion','$email','$name','$apellido','$sexo','$tlf',$fecha_nac,'$email_e','$type_a','$agente','$pais','$user','$date')");

    if ($insert) {
        $id=$this->db->insert_id;
        foreach ($listas as $value) {
            $insert=$this->db->query("INSERT INTO subscriber_lists(id_list,id_subscriber,id_user,create_date) VALUES ($value,$id,'$user','$date')");
        }
    }
    return $insert1;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
*/
public function edit_subscriber($identificacion,$name,$apellido,$email,$email_e,$type_a,$agente,$tlf,$fecha_nac,$sexo,$pais,$listas,$status,$id,$user,$agregar_p,$eliminar_p){
    $date=date('Y-m-d H:i:s');
    if (count($eliminar_p) > 0) {
        foreach ($eliminar_p as $e_emp) {
            $dato1=$this->db->query("DELETE FROM subscriber_lists WHERE id_list='$e_emp' AND id_subscriber='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_p) > 0) {
        foreach ($agregar_p as $a_emp) {
            $dato2=$this->db->query("INSERT INTO subscriber_lists(id_subscriber,id_list,id_user,create_date) VALUES ('$id','$a_emp','$user','$date')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }
    $fecha_nac=(empty($fecha_nac))? "NULL" : "'$fecha_nac'";
    $update=$this->db->query("UPDATE subscribers SET email_subscriber='$email',name_subscriber='$name',surname_subscriber='$apellido',sex_subscriber='$sexo',identification_subscriber='$identificacion',phones_subscriber='$tlf',date_birth=$fecha_nac,email_emergency='$email_e',type_agent='$type_a',agent_subscriber='$agente',id_country='$pais',id_status='$status',id_user='$user',create_date='$date' WHERE id_subscriber='$id'");
    return $update;
}
/**
* Chequear si subscriber.
*
*Funcion para validar si subscriber existe*
*
* @return Boolean  
* @param Int $id id de subscriber
*/
public function check_subscriber($id){
    $consulta=$this->db->query("SELECT 1 FROM subscribers WHERE id_subscriber='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_subscriber($id){
    $delete=$this->db->query("DELETE FROM subscribers WHERE id_subscriber='$id'");
    return $delete;
}

/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
*/
public function register_air($fecha_e,$id,$user){
    $date=date('Y-m-d H:i:s');
    $fecha_e = explode("-", $fecha_e);
    $fecha_inicio = date("Y-m-d", strtotime($fecha_e[0]));
    $fecha_fin = date("Y-m-d", strtotime($fecha_e[1]));
    $update=$this->db->query("UPDATE subscribers SET date_start='$fecha_inicio',date_expiration='$fecha_fin',id_user='$user',create_date='$date' WHERE id_subscriber='$id'");

    return $update;
}


/**
* Chequear si localizador.
*
*Funcion para validar si localizador existe*
*
* @return Boolean  
* @param Int $id id de localizador
*/
public function chek_localizador($id){
    $consulta=$this->db->query("SELECT 1 FROM subscribers WHERE reference='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}

/**
* Chequear si identificacion.
*
*Funcion para validar si identificacion existe*
*
* @return Boolean  
* @param Int $id id de identificacion
*/
public function chekc_identifiacion($id){
    $consulta=$this->db->query("SELECT 1 FROM subscribers WHERE identification_subscriber='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}

/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
*/
public function register_subscriber_masivo($listas,$completos,$user){
    $num=0;
    foreach ($completos as $value) {
        $date=date('Y-m-d H:i:s');
        $reference=$value->reference;
        if ($reference == "#") {
            $reference="NULL";
        }else{
            $reference="'$reference'";
        } 
        $emision=$value->emision;
        if ($emision == "#") {
            $emision="NULL";
        }else{
            $emision="'$emision'";
        }
        $inicio=$value->inicio;

        if ($inicio == "#") {
            $inicio="NULL";
        }else{
            $inicio="'$inicio'";
        }
        $fin=$value->fin;

        if ($fin == "#") {
            $fin="NULL";
        }else{
            $fin="'$fin'";
        }
        $paisorigen=$value->paisorigen;
        $name=$value->name;
        $name = str_replace ("'", "&apos;",$name);
        $apellido=$value->apellido;
        $apellido = str_replace ("'", "&apos;",$apellido);
        $fecha_nac=$value->fecha_nac;
        if ($fecha_nac == "#") {
            $fecha_nac="NULL";
        }else{
            $fecha_nac="'$fecha_nac'";
        }
        $identifiacion=$value->identifiacion;
        $email=$value->email;
        $telefono=$value->telefono;
        $sexo=$value->sexo;
        if ($sexo == "#") {
            $sexo="NULL";
        }else{
            $sexo="'$sexo'";
        }
        $email_e=$value->email_e;
        if ($email_e == "#") {
            $email_e="NULL";
        }else{
            $email_e="'$email_e'";
        }
        $perfil=$value->perfil;
        $agente=$value->agente;

        $insert=$this->db->query("INSERT INTO subscribers(reference,email_subscriber,name_subscriber,surname_subscriber,phones_subscriber,date_birth,date_issue,date_start,date_expiration,identification_subscriber,id_country,id_status,id_user,create_date,email_emergency,type_agent,agent_subscriber,sex_subscriber) VALUES ($reference,'$email','$name','$apellido','$telefono',$fecha_nac,$emision,$inicio,$fin,'$identifiacion','$paisorigen','1','$user','$date',$email_e,'$perfil','$agente',$sexo)");

        if ($insert) {
            $date=date('Y-m-d H:i:s');
            $id_subscriber=$this->db->insert_id;
            foreach ($listas as $value) {
                $insert=$this->db->query("INSERT INTO subscriber_lists(id_list,id_subscriber,id_user,create_date) VALUES ('$value','$id_subscriber','$user','$date')");
            }
        }else{
            break;
        }
    }
    return $insert;
}


}
?>