<?php
require_once('includes/definition.php');

class schedules_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_schedules($datos,$user){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_schedule as id,b.event_schedule as title,b.date_schedule as start,b.color_event as color FROM advisers_schedules as b WHERE b.id_adviser='$user' ORDER BY b.id_schedule ASC ");
    }else{
        $consulta=$this->db->query("SELECT b.id_schedule as id,b.name_schedule as name,b.id_status as status FROM schedules as b WHERE b.id_schedule='$datos' AND b.id_adviser='$user'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
/*public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM schedules WHERE name_schedule='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM schedules WHERE name_schedule='$datos' AND id_schedule !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Validar de fecha.
*
*
* @return Boolean
*/
function validateDate($date, $format = 'Y-m-d')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_schedule($name,$fecha,$color,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO advisers_schedules(id_adviser, date_schedule,event_schedule,color_event,create_date) VALUES ('$user','$fecha','$name','$color','$date')");

    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_schedule($name,$fecha,$color,$id,$user){
    $date=date('Y-m-d H:i:s');
    if (empty($fecha)) {
    $update=$this->db->query("UPDATE advisers_schedules SET event_schedule='$name',color_event='$color',create_date='$date' WHERE id_schedule='$id' AND id_adviser='$user'");
    }else{
    $update=$this->db->query("UPDATE advisers_schedules SET event_schedule='$name',date_schedule='$fecha',color_event='$color',create_date='$date' WHERE id_schedule='$id' AND id_adviser='$user' ");   
    }
    return $update;
}
/**
* Chequear si schedule.
*
*Funcion para validar si schedule existe*
*
* @return Boolean  
* @param Int $id id de schedule
*/
public function check_schedule($id,$user){
    $consulta=$this->db->query("SELECT 1 FROM advisers_schedules WHERE id_schedule='$id' AND id_adviser='$user' ");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_schedule($id,$user){
    $delete=$this->db->query("DELETE FROM advisers_schedules WHERE id_schedule='$id' AND id_adviser='$user'");
    return $delete;
}

}
?>