<?php
require_once('includes/definition.php');

class reports_bee_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de merchand.
*
* Consulta de historial merchand registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de files registrados
* @param Int $datos id del usuario
*/
public function query_report_merchand($fechai,$fechaf){
    if (is_null($fechai)) {   
        $fechaf=date('Y-m-d');
        $fechai=date("Y-m-d",strtotime($fecha_actual."- 1 month"));
    }

    $consulta=$this->db->query("SELECT lpad(b.id_buy , 6, 0) as poliza,DATE_FORMAT(p.create_date, '%Y-%m-%d') as fecha,p.transid,p.accountnumber as tarjeta,b.total_payment as total FROM payment_transactions as p INNER JOIN insurance_payment as b ON (p.id_transaction=b.id_transaction)  WHERE DATE_FORMAT(p.create_date, '%Y-%m-%d') BETWEEN '$fechai' AND '$fechaf' AND p.payment_platform='1' AND b.id_buy IS NOT NULL ORDER BY p.id_transaction ASC ");

    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}

/**
* Consulta de files.
*
* Consulta de files registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de files registrados
* @param Int $datos id del usuario
*/
public function query_report_files($opcion){
    if ($opcion == "1") {
    $consulta=$this->db->query("SELECT f.id_adviser as id,CONCAT(a.name_adviser,' ',a.surname_adviser) as name,lpad(a.id_adviser , 6, 0) as codigo,(SELECT name_agency FROM agencies WHERE id_agency=a.id_agency) as padre,f.name_file as archivo,'6' as perfil FROM files as f INNER JOIN advisers as a ON (f.id_adviser=a.id_adviser) WHERE f.type_file='1'  ");
    }else{
    $consulta=$this->db->query("SELECT f.id_agency as id,a.name_agency as name,(SELECT name_agency FROM agencies WHERE id_agency=a.id_father) as padre,IF(a.level_agency =1, 'Master', 'Agencia') as perfil_name,a.id_profile as perfil,f.name_file as archivo FROM files as f INNER JOIN agencies as a ON (f.id_agency=a.id_agency) WHERE f.type_file='1'  ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Consulta de files w8 o w9.
*
* Consulta de files w8 o w9 registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de files w8 o w9 registrados
* @param Int $datos id del usuario
*/
public function query_w8_w9($id,$perfil){
    if ($perfil == "6") {
    $consulta=$this->db->query("SELECT f.name_file as archivo FROM files as f WHERE f.type_file='2' AND f.id_adviser='$id'  ");
    }else{
    $consulta=$this->db->query("SELECT f.name_file as archivo FROM files as f WHERE f.type_file='2' AND f.id_agency='$id'  ");
    }
    $archivo="";
    while($filas=$consulta->fetch_assoc()){
        $archivo=$filas['archivo'];
    }
    return $archivo;
}


}
?>