<?php
require_once('includes/definition.php');

class declaration_health_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_declaration_health($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_declaration_health as id,b.name_declaration_health as name,IF(b.option_detail > 1, 'No', 'Si') as detalle,s.status_name as status,s.status_color as color FROM declaration_health as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_declaration_health as id,b.name_declaration_health as name,b.option_detail as detalle,b.id_status as status FROM declaration_health as b WHERE b.id_declaration_health='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM declaration_health WHERE name_declaration_health='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM declaration_health WHERE name_declaration_health='$datos' AND id_declaration_health !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_declaration_health($name,$opcion_detalle,$status,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO declaration_health(name_declaration_health,option_detail,id_status,id_user,create_date) VALUES ('$name','$opcion_detalle','$status','$user','$date')");

    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_declaration_health($name,$opcion_detalle,$status,$user,$id){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE declaration_health SET name_declaration_health='$name',option_detail='$opcion_detalle',id_status='$status',id_user='$user',create_date='$date' WHERE id_declaration_health='$id'");
    return $update;
}
/**
* Chequear si declaration_health.
*
*Funcion para validar si declaration_health existe*
*
* @return Boolean  
* @param Int $id id de declaration_health
*/
public function check_declaration_health($id){
    $consulta=$this->db->query("SELECT 1 FROM declaration_health WHERE id_declaration_health='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}

/**
* Chequear si check_declaration_age_groups.
*
*Funcion para validar si check_declaration_age_groups existe*
*
* @return Boolean  
* @param Int $id id de check_declaration_age_groups
*/
public function check_declaration_age_groups($declaracion,$id){
    $consulta=$this->db->query("SELECT 1 FROM declaration_age_groups WHERE id_setting='$id' AND id_declaration_health='$declaracion' ");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}

/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function check_form($id){
    $consulta=$this->db->query("SELECT 1 FROM insurance_declaration_health WHERE id_declaration_health='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_declaration_health($id){
    $delete=$this->db->query("DELETE FROM declaration_health WHERE id_declaration_health='$id'");
    return $delete;
}

/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function check_group($id){
    $consulta=$this->db->query("SELECT 1 FROM age_groups WHERE id_group='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_settings($datos){
    $consulta=$this->db->query("SELECT b.id_setting as id,s.start_age as edad_d,s.end_age as edad_h,b.points as puntos,b.id_group as grupo FROM declaration_age_groups as b INNER JOIN age_groups as s ON (b.id_group=s.id_group) WHERE id_declaration_health='$datos' ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Registrar ajustes.
*
*Funcion para registrar ajustes*
*
* @return Boolean  
*/
public function register_declaration_age_groups($grupo,$puntos,$id,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO declaration_age_groups(id_declaration_health,id_group,points,id_user,create_date) VALUES ('$id','$grupo','$puntos','$user','$date')");

    return $insert;
}
/**
* Editar ajustes.
*
*Funcion para editar ajustes*
*
* @return Boolean  
*/
public function edit_declaration_age_groups($grupo,$puntos,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE declaration_age_groups SET id_group='$grupo',points='$puntos',id_user='$user',create_date='$date' WHERE id_setting='$id'");
    return $update;
}
/**
* Eliminar ajuste.
*
*Funcion para eliminar ajuste*
*
* @return Boolean  
* @param Int $id id de ajuste
*/
public function delete_declaration_age_groups($id,$opcion,$user){
    $date=date('Y-m-d H:i:s');
    if ($opcion == 1) {
    $delete=$this->db->query("DELETE FROM declaration_age_groups WHERE id_setting='$id'");
    }else{
    $update=$this->db->query("UPDATE declaration_age_groups SET id_status='2',id_user='$user',create_date='$date' WHERE id_setting='$id'");  
    }
    return $delete;
}

}
?>