<?php
require_once('includes/definition.php');
class commissions_reports_model{

    private $db;
    private $query;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
    }


/**
* Consulta de agencias master.
*
* Consulta de agencias master registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de agencias master registrados
* @param Int $datos id del usuario
*/
public function query_agencies_masters(){
    $consulta=$this->db->query("SELECT b.id_agency as id,b.name_agency as name FROM agencies as b INNER JOIN status as s ON (b.id_status=s.id_status) WHERE b.level_agency = 1 ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Consulta de agencias.
*
* Consulta de agencias registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de agencias registrados
* @param Int $datos id del usuario
*/
public function query_agencies($user){
    $consulta=$this->db->query("SELECT b.id_agency as id,b.name_agency as name FROM agencies as b WHERE b.level_agency = 2 AND b.id_father='$user' ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_advisers($user){
    $consulta=$this->db->query("SELECT b.id_adviser as id,CONCAT(b.name_adviser,' ', b.surname_adviser) as name,lpad(b.id_adviser , 6, 0) as code,b.id_agency as agencia FROM advisers as b WHERE b.id_agency='$user' ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Consulta de ventas agencias.
*
* Consulta de agencias  registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de agencias registrados
*/
public function query_buy_agencies($agencia){
    $inicio = date("Y-m-01");
    $fin = date("Y-m-t");
    $consulta=$this->db->query("SELECT lpad(b.id_buy , 6, 0) as id,pago.total_payment as totalpago,(SELECT commission as comision FROM agencies_commissions WHERE id_product=p.id_product AND id_agency=b.id_agency ) as comision FROM insurance_buy as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) INNER JOIN insurance_payment as pago ON (b.id_buy=pago.id_buy) WHERE DATE_FORMAT(b.create_date, '%Y-%m-%d') BETWEEN '$inicio' AND '$fin' AND b.id_agency='$agencia' AND b.user_profile!='6'  ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Consulta de ventas agencias master.
*
* Consulta de agencias master registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de agencias master registrados
*/
public function query_buy_advisers($asesor){
    $inicio = date("Y-m-01");
    $fin = date("Y-m-t");
    $consulta=$this->db->query("SELECT lpad(b.id_buy , 6, 0) as id,pago.total_payment as totalpago,(SELECT commission as comision FROM advisers_commissions WHERE id_product=p.id_product AND id_adviser=b.id_adviser ) as comision FROM insurance_buy as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) INNER JOIN insurance_payment as pago ON (b.id_buy=pago.id_buy) WHERE DATE_FORMAT(b.create_date, '%Y-%m-%d') BETWEEN '$inicio' AND '$fin' AND b.id_adviser='$asesor' AND b.user_profile='6'  ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}


}
?>