<?php
require_once('includes/definition.php');

class categories_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_categories($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_category as id,b.name_category as name,(SELECT COUNT(id_category) FROM blog_categories WHERE id_category=b.id_category) as cantidad,s.status_name as status,s.status_color as color FROM categories as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_category as id,b.name_category as name,b.id_status as status FROM categories as b WHERE b.id_category='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM categories WHERE name_category='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM categories WHERE name_category='$datos' AND id_category !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_category($name,$status,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO categories(name_category, id_status,id_user,create_date) VALUES ('$name','$status','$user','$date')");

    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_category($name,$status,$user,$id){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE categories SET name_category='$name',id_status='$status',id_user='$user',create_date='$date' WHERE id_category='$id'");
    return $update;
}
/**
* Chequear si category.
*
*Funcion para validar si category existe*
*
* @return Boolean  
* @param Int $id id de category
*/
public function check_category($id){
    $consulta=$this->db->query("SELECT 1 FROM categories WHERE id_category='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function check_blog($id){
    $consulta=$this->db->query("SELECT 1 FROM blog_categories WHERE id_category='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_category($id){
    $delete=$this->db->query("DELETE FROM categories WHERE id_category='$id'");
    return $delete;
}

}
?>