<?php
require_once('includes/definition.php');
require_once('includes/send_email.php');

class campaigns_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;
    private $correo_1;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
        $this->correo_1= new emails();
    }

/**
* Consulta de campaign.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function query_campaigns($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_campaign as id,b.name_campaign as name,DATE_FORMAT(b.send_date, '%Y-%m-%d') as fecha_envio,b.subject_campaign as asunto,u.user_name as usuario,b.id_status,s.status_name as status,s.status_color as color FROM campaigns as b INNER JOIN status as s ON (b.id_status=s.id_status) INNER JOIN users as u ON (b.id_user=u.id_user) ORDER BY b.id_campaign DESC");
    }else{
        $consulta=$this->db->query("SELECT b.id_campaign as id,b.name_campaign as name,DATE_FORMAT(b.send_date, '%Y-%m-%d') as fecha_envio,b.subject_campaign as asunto,b.id_status as status,b.description_campaign as descripcion FROM campaigns as b WHERE b.id_campaign='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign recibidad.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function lists_subscriber($datos,$lista){
    if (empty($lista)) {   
        $consulta=$this->db->query("SELECT CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,l.name_list as lista  FROM campaign_send as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) WHERE b.id_campaign='$datos'  ORDER BY b.id_list DESC");
    }else{
        $consulta=$this->db->query("SELECT CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,l.name_list as lista  FROM campaign_send as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) WHERE b.id_campaign='$datos' AND b.id_list='$lista'  ORDER BY b.id_list DESC");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function lists_subscriber_no($datos,$lista){
    if (empty($lista)) {   
        $consulta=$this->db->query("SELECT CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,l.name_list as lista  FROM campaign_fails as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) WHERE b.id_campaign='$datos'  ORDER BY b.id_list DESC");
    }else{
        $consulta=$this->db->query("SELECT CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,l.name_list as lista  FROM campaign_fails as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) WHERE b.id_campaign='$datos' AND b.id_list='$lista'  ORDER BY b.id_list DESC");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function dateils_campaign($datos){
    $consulta=$this->db->query("SELECT b.name_campaign as name,DATE_FORMAT(b.send_date, '%Y-%m-%d') as fecha_envio,b.subject_campaign as asunto,b.description_campaign as descripcion,u.user_name as usuario,b.id_status,s.status_name as status,s.status_color as color FROM campaigns as b INNER JOIN status as s ON (b.id_status=s.id_status) INNER JOIN users as u ON (b.id_user=u.id_user) WHERE b.id_campaign='$datos' ORDER BY b.id_campaign DESC");

    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Validar de categorias.
*
* Validar de categorias registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de categorias registrados
* @param Int $datos id del usuario
*/
public function check_lists_campaigns($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
        $consulta=$this->db->query("SELECT b.id_list as id FROM campaign_lists as b WHERE b.id_campaign='$datos' ");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas['id'];
        }
    }else{
        $consulta=$this->db->query("SELECT b.id_list as id, c.name_list as name,(SELECT count(id_list) FROM campaign_send WHERE id_campaign='$datos' AND id_list=b.id_list) as suscriptores,(SELECT count(id_list) FROM campaign_fails WHERE id_campaign='$datos' AND id_list=b.id_list) as suscriptores_no FROM campaign_lists as b INNER JOIN lists as c ON (b.id_list=c.id_list) WHERE b.id_campaign='$datos' ");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas;
        }
    }
    return $query;
}
/**
* Validar de fecha.
*
*
* @return Boolean
*/
function validateDate_now($date)
{
    $fecha=date('Y-m-d');
    $fechai = date("Y-m-d", strtotime($fecha));
    $fechaf = date("Y-m-d", strtotime($date));
    $date1=date_create($fechai);
    $date2 = date_create($fechaf);
    $diff = $date1->diff($date2);
    $diff= $diff->format('%R%a');
    $diff = substr($diff, 0,1);
    if($diff == "-"){
        return false;
    }else{
        return true;
    }
}
/**
* Chequear si nombre de Campaña existe.
*
*Funcion para consultar nombre de Campaña registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de Campaña,Int $id del Campaña
*/
public function check_status ($datos){
    $datos=trim($datos);
    $consulta=$this->db->query("SELECT 1 FROM status WHERE id_status ='$datos' ");
    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si nombre de Campaña existe.
*
*Funcion para consultar nombre de Campaña registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de Campaña,Int $id del Campaña
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM campaigns WHERE name_campaign='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM campaigns WHERE name_campaign='$datos' AND id_campaign !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}

/**
* Registrar Campaña.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function register_campaign($name,$asunto,$fecha_e,$descripcion,$listas,$status,$user){
    $date=date('Y-m-d H:i:s');
    $fecha_a=date('Y-m-d');
    $descripcion = str_replace ("'", "&apos;",$descripcion);
    $insert=$this->db->query("INSERT INTO campaigns(name_campaign,subject_campaign,send_date,description_campaign,id_status,id_user,create_date) VALUES ('$name','$asunto','$fecha_e','$descripcion','$status','$user','$date')");
    if ($insert) {
        $id=$this->db->insert_id;
        foreach ($listas as $value) {
            $insert=$this->db->query("INSERT INTO campaign_lists(id_list,id_campaign,id_user,create_date) VALUES ($value,$id,'$user','$date')");
        }
        if ($status=="5" & $fecha_a == $fecha_e) {
            $insert=$this->debug_lists($listas,$asunto,$descripcion,$id,$status);
            if ($insert) {
                $insert=$this->db->query("UPDATE campaigns SET id_status='3' WHERE id_campaign='$id'");
            }
        }elseif ($status=="5" & $fecha_a != $fecha_e) {
            $insert=$this->db->query("UPDATE campaigns SET id_status='6' WHERE id_campaign='$id'");
        }elseif ($status=="7") {
            $listas=['1'];
            $insert=$this->debug_lists($listas,$asunto,$descripcion,$id,$status);
        }
    }
    return $insert;
}

/**
* Editar Campaña.
*
*Funcion para editar Campaña*
*
* @return Boolean  
*/
public function edit_campaign($agregar_s,$eliminar_s,$name,$asunto,$fecha_e,$descripcion,$status,$listas,$user,$id){
    $date=date('Y-m-d H:i:s');
    $fecha_a=date('Y-m-d');
    if (count($eliminar_s) > 0) {
        foreach ($eliminar_s as $e_emp) {
            $dato1=$this->db->query("DELETE FROM campaign_lists WHERE id_list='$e_emp' AND id_campaign='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_s) > 0) {
        foreach ($agregar_s as $a_emp) {
            $dato2=$this->db->query("INSERT INTO campaign_lists(id_list,id_campaign,id_user,create_date) VALUES ('$a_emp','$id','$user','$date')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }
    $descripcion = str_replace ("'", "&apos;",$descripcion);
    $update=$this->db->query("UPDATE campaigns SET name_campaign='$name',subject_campaign='$asunto',send_date='$fecha_e',description_campaign='$descripcion',id_status='$status',id_user='$user',create_date='$date' WHERE id_campaign='$id'");
    if ($update) {
        if ($status=="5" & $fecha_a == $fecha_e) {
            $insert=$this->debug_lists($listas,$asunto,$descripcion,$id,$status);
            if ($insert) {
                $insert=$this->db->query("UPDATE campaigns SET id_status='3' WHERE id_campaign='$id'");
            }
        }elseif ($status=="5" & $fecha_a != $fecha_e) {
            $insert=$this->db->query("UPDATE campaigns SET id_status='6' WHERE id_campaign='$id'");
        }elseif ($status=="7") {
            $listas=['1'];
            $update=$this->debug_lists($listas,$asunto,$descripcion,$id,$status);
        }
    }

    return $update;
}
/**
* Depurar listado de suscriptores.
*
*Funcion para depurar cantidad de suscriptores para la el envio*
*
* @return Boolean  
*/
public function debug_lists($listas,$asunto,$descripcion,$id,$status){
    $date=date('Y-m-d H:i:s');
    $fecha_a=date('Y-m-d');
    $query=[];
    foreach ($listas as $value) {
        $consulta=$this->db->query("SELECT b.id_subscriber as id,b.id_list as lista,s.name_subscriber as name,s.email_subscriber as email,s.surname_subscriber as apellido,s.date_birth as fecha_n FROM subscriber_lists as b INNER JOIN subscribers as s ON (b.id_subscriber=s.id_subscriber) WHERE b.id_list='$value' AND s.id_status='1' AND (email_subscriber !='#' OR email_subscriber='' OR email_subscriber IS NULL)");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas;
        }
    }
    $send=$this->correo_1->send_campaign($query,$asunto,$descripcion);
    if ($send['status']) {
        $suscriptores_send=$send['completos'];
        $suscriptores_fail=$send['fallidos'];
        if ($status !== "7") {
            $send=$this->suscriptores_send($suscriptores_send,$id);
            $send1=$this->suscriptores_fail($suscriptores_fail,$id);
        }
        return true;
    }else{
        return false;
    }
}
/**
* Registrar Campaña.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function suscriptores_send($suscriptores,$campaigns){
    $date=date('Y-m-d H:i:s');
    foreach ($suscriptores as $value) {
        $suscriptor=$value->id;
        $lista=$value->lista;
        $insert=$this->db->query("INSERT INTO campaign_send(id_campaign,id_subscriber,id_list,create_date) VALUES ('$campaigns','$suscriptor','$lista','$date')");
    }
    return $insert;
}
/**
* Registrar Campaña.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function suscriptores_fail($suscriptores,$campaigns){
    $date=date('Y-m-d H:i:s');
    foreach ($suscriptores as $value) {
        $suscriptor=$value->id;
        $lista=$value->lista;
        $insert=$this->db->query("INSERT INTO campaign_fails(id_campaign,id_subscriber,id_list,create_date) VALUES ('$campaigns','$suscriptor','$lista','$date')");
    }
    return $insert;
}
/**
* Chequear si campaign.
*
*Funcion para validar si campaign existe*
*
* @return Boolean  
* @param Int $id id de campaign
*/
public function check_campaign($id){
    $consulta=$this->db->query("SELECT 1 FROM campaigns WHERE id_campaign='$id' AND id_status !='3' ");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Registrar Campaña Duplicada.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function duplicate_campaign($datos,$listas,$user){
    $date=date('Y-m-d H:i:s');
    $fecha_e=date('Y-m-d');
    foreach ($datos as $value) {
        $name=$value['name'].' Duplicada';
        $asunto=$value['asunto'];
        $descripcion=$value['descripcion'];
        $insert=$this->db->query("INSERT INTO campaigns(name_campaign,subject_campaign,send_date,description_campaign,id_status,id_user,create_date) VALUES ('$name','$asunto','$fecha_e','$descripcion','4','$user','$date')");
        if ($insert) {
            $id=$this->db->insert_id;
            foreach ($listas as $value) {
                $value1=$value['id'];
                $insert=$this->db->query("INSERT INTO campaign_lists(id_list,id_campaign,id_user,create_date) VALUES ($value1,$id,'$user','$date')");
            }
        }
    }
    return $insert;
}
/**
* Registrar Campaña.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function approve_campaign($datos,$listas,$user){
    $date=date('Y-m-d H:i:s');
    $fecha_e=date('Y-m-d');
    foreach ($datos as $value) {
        $status="3";
        $id=$value['id'];
        $asunto=$value['asunto'];
        $descripcion=$value['descripcion'];
        $insert=$this->debug_lists($listas,$asunto,$descripcion,$id,$status);
        if ($insert) {
        $insert=$this->db->query("UPDATE campaigns SET send_date='$fecha_e',id_status='$status',id_user='$user',create_date='$date' WHERE id_campaign='$id'");
        }
    }
    return $insert;
}
/**
* Eliminar Campaña.
*
*Funcion para eliminar Campaña*
*
* @return Boolean  
* @param Int $id id de Campaña
*/
public function delete_campaign($id){
    $delete=$this->db->query("DELETE FROM campaigns WHERE id_campaign='$id'");
    return $delete;
}

}
?>