<?php
require_once('includes/definition.php');

class banners_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de bannerss.
*
* Consulta de bannerss registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de bannerss registrados
* @param Int $datos id del usuario
*/
public function query_banners($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_banner as id,b.name_banner as name,b.description_banner as description,b.link_banner as link,b.image_banner as image,s.status_name as status,s.status_color as color FROM banners as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_banner as id,b.name_banner as name,b.id_status as status,b.description_banner as description,b.link_banner as link,b.image_banner as image FROM banners as b WHERE b.id_banner='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de banners existe.
*
*Funcion para consultar nombre de banners registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de banners,Int $id del banners
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM banners WHERE name_banner='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM banners WHERE name_banner='$datos' AND id_banner !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar banners.
*
*Funcion para registrar banners*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la banners,String $doc ruc de la banners,String $direccion direccion de la banners,Int $status status de la banners
*/
public function register_banner($name,$link,$descripcion,$imagen,$user){
    $date=date('Y-m-d H:i:s');
    $name_archivo = str_replace(" ", "_", $name);
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $insert=$this->db->query("INSERT INTO banners(name_banner,description_banner,link_banner,image_banner,id_user,create_date) VALUES ('$name','$descripcion','$link','$name_image','$user','$date')");
    if ($insert) {
    $location=$_SESSION['ruta_img'].'banners_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    }
    return $insert;
}
/**
* Editar banners.
*
*Funcion para editar banners*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la banners,String $doc ruc de la banners,String $direccion direccion de la banners,Int $status status de la banners,Int $data1 id de banners
*/
public function edit_banner($name,$link,$descripcion,$imagen,$status,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE banners SET name_banner='$name',description_banner='$descripcion',link_banner='$link',id_status='$status',id_user='$user',create_date='$date' WHERE id_banner='$id'");
    $name_archivo = str_replace(" ", "_", $name);
    if (!is_null($imagen)) {
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $location=$_SESSION['ruta_img'].'banners_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    $update=$this->db->query("UPDATE banners SET image_banner='$name_image' WHERE id_banner='$id'");
    }
    return $update;
}
/**
* Chequear si banner.
*
*Funcion para validar si banner existe*
*
* @return Boolean  
* @param Int $id id de banner
*/
public function check_banner($id){
    $consulta=$this->db->query("SELECT 1 FROM banners WHERE id_banner='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Eliminar banners.
*
*Funcion para eliminar banners*
*
* @return Boolean  
* @param Int $id id de banners
*/
public function delete_banner($id){
    $delete=$this->db->query("DELETE FROM banners WHERE id_banner='$id'");
    if ($delete) {
    $nombre=$this->query_banners($id);
    $nombre=$nombre['image'];
    $location=$_SESSION['ruta_img'].'banners_img/'.$nombre;
    unlink($location);
    }
    return $delete;
}

}
?>