<?php
require_once('includes/definition.php');
require_once('includes/send_email.php');

class agencies_masters_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;
    private $correo_1;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
        $this->correo_1= new emails();

    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_agencies_masters($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_agency as id,b.name_agency as name,b.phones_agency as phone,b.email_agency as email,(SELECT name_agency FROM agencies WHERE id_agency=b.id_father) as padre,s.status_name as status,s.status_color as color, CONCAT('<b>Id:</b> ',b.id_reference,'<br><b>Nombre:</b> ',b.names_reference,'<br><b>Comision % :</b> ',b.comision_fee) as reference FROM agencies as b INNER JOIN status as s ON (b.id_status=s.id_status) WHERE level_agency = 1 ");
    }else{
        $consulta=$this->db->query("SELECT b.id_agency as id,b.name_agency as name,b.id_status as status,b.phones_agency as tlf,b.email_agency as email,b.id_reference as id_f,b.names_reference as name_f,b.comision_fee as comision_f FROM agencies as b WHERE b.id_agency='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
/*public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM agencies WHERE email_agency='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM agencies WHERE email_agency='$datos' AND id_agency !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}

/**
* Chequear si nombre de usuario existe.
*
*Funcion para chequear nombre de usuario existe*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de usuario,Int $id id del usuario
*/
public function check_name ($datos,$id){
    $consulta1=$this->db->query("SELECT 1 FROM advisers WHERE email_adviser='$datos'"); 
    $consulta2=$this->db->query("SELECT 1 FROM users WHERE email_user='$datos'"); 
    if (is_null($id)) {
        $consulta3=$this->db->query("SELECT 1 FROM agencies WHERE email_agency='$datos'");
    }else{
        $consulta3=$this->db->query("SELECT 1 FROM agencies WHERE email_agency='$datos' AND id_agency !='$id' ");
    }
    $count_consulta1=$consulta1->num_rows;
    $count_consulta2=$consulta2->num_rows;
    $count_consulta3=$consulta3->num_rows;
    if ($count_consulta1 > 0 || $count_consulta2 > 0 || $count_consulta3 > 0) {
        return false;
    }
    return true;
    
}


/**
* Consulta de comision.
*
* Consulta de comision registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de comision registrados
* @param Int $datos id del usuario
*/
public function check_comision($datos,$comision){
    $consulta=$this->db->query("SELECT 1 FROM products as b  WHERE b.id_product='$datos' AND b.percentage_agencies_master >=$comision ");

    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return false;
    }
    return true;
}
/**
* Consulta de comision.
*
* Consulta de comision registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de comision registrados
* @param Int $datos id del usuario
*/
public function check_comision_children($datos,$comision){
    $consulta=$this->db->query("SELECT 1 FROM products as b  WHERE b.id_product='$datos' AND b.percentage_agencies >=$comision ");

    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Consulta de comision.
*
* Consulta de comision registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de comision registrados
* @param Int $datos id del usuario
*/
public function query_comision($opcion,$agencia){
    if ($opcion == 1) {   
        $consulta=$this->db->query("SELECT b.id_product as id FROM agencies_commissions as b WHERE b.id_agency='$agencia' ");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas['id'];
        }
    }else{
        $consulta=$this->db->query("SELECT ag.id_product as id,ag.commission as comision,p.name_product as name FROM agencies_commissions as ag INNER JOIN products as p ON (ag.id_product=p.id_product) WHERE ag.id_agency='$agencia' ");
        $query=[];
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas;
        }}
        return $query;
    }


/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_agencies_master($name,$tlf,$productos,$comision,$email_a,$user,$clave_encrypt,$body_mail,$id_reference,$name_reference,$comision_fee){
    $date=date('Y-m-d H:i:s');

    $id_reference=(empty($id_reference)) ? 'NULL' : "'$id_reference'";
    $name_reference=(empty($name_reference)) ? 'NULL' : "'$name_reference'";
    $comision_fee=(empty($id_reference)) ? 'NULL' : "'$comision_fee'";

    $insert=$this->db->query("INSERT INTO agencies(name_agency,phones_agency,email_agency,id_father,level_agency,id_user,create_date,id_profile,pass_agency,id_reference,names_reference,comision_fee) VALUES ('$name','$tlf','$email_a','1','1','$user','$date','4','$clave_encrypt',$id_reference,$name_reference,$comision_fee)");
    if ($insert) {
        $id=$this->db->insert_id;
        $x=count($productos);
        for ($i=0; $i < $x; $i++) { 
            $value=str_replace('.','',$comision[$i]);
            $value=str_replace(',','.', $value);
            $insert=$this->db->query("INSERT INTO agencies_commissions(id_agency,id_product,commission) VALUES ('$id','$productos[$i]','$value')");

        }
        $send=$this->correo_1->send_email($email_a,$name,'Bienvenido a Bee Insurance',$body_mail);
        if (!$send) {
        return ['status'=>false,'code'=>'1'];
        }
    }
        return ['status'=>$insert,'code'=>'2'];
    }
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_agencies_master($name,$tlf,$productos,$agregar_s,$eliminar_s,$comision,$email_a,$status,$id,$user,$id_reference,$name_reference,$comision_fee){
    $date=date('Y-m-d H:i:s');
    $i=0;
    foreach ($productos as $producto) {
    $value=str_replace('.','',$comision[$i]);
    $value=str_replace(',','.', $value);
    $dato1=$this->db->query("UPDATE agencies_commissions SET commission='$value' WHERE id_product='$producto' AND id_agency='$id'");
    $i++;
    }
    if (count($eliminar_s) > 0) {
        foreach ($eliminar_s as $e_emp) {
            $dato1=$this->db->query("DELETE FROM agencies_commissions WHERE id_product='$e_emp' AND id_agency='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_s) > 0) {
        foreach ($agregar_s as $a_emp) {
            $i = array_search($a_emp,$agregar_s,false);
            $value=str_replace('.','',$comision[$i]);
            $value=str_replace(',','.', $value);
            $insert=$this->db->query("INSERT INTO agencies_commissions(id_agency,id_product,commission) VALUES ('$id','$a_emp','$value')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }

    $id_reference=(empty($id_reference)) ? 'NULL' : "'$id_reference'";
    $name_reference=(empty($name_reference)) ? 'NULL' : "'$name_reference'";
    $comision_fee=(empty($id_reference)) ? 'NULL' : "'$comision_fee'";

    $update=$this->db->query("UPDATE agencies SET name_agency='$name',phones_agency='$tlf',email_agency='$email_a',id_status='$status',id_user='$user',create_date='$date',id_reference=$id_reference,names_reference=$name_reference,comision_fee=$comision_fee WHERE id_agency='$id'");
    return $update;
}
/**
* Chequear si agencie.
*
*Funcion para validar si agencie existe*
*
* @return Boolean  
* @param Int $id id de agencie
*/
public function check_agencies_master($id){
    $consulta=$this->db->query("SELECT 1 FROM agencies WHERE id_agency='$id' AND level_agency = 1");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
/*public function check_game($id){
    $consulta=$this->db->query("SELECT 1 FROM games WHERE id_agency='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_agencies_master($id){
    $delete=$this->db->query("DELETE FROM agencies WHERE id_agency='$id'");
    return $delete;
}
/**
* Consulta de productos.
*
* Consulta de productos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de productos registrados
*/
public function select_products($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_product as id,b.name_product as name,b.percentage_agencies_master as comision FROM products as b WHERE b.id_status=1 ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM products as b WHERE b.id_product='$datos' AND b.id_status=1 ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
}
?>