<?php
require_once('includes/definition.php');

class ads_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de adss.
*
* Consulta de adss registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de adss registrados
* @param Int $datos id del usuario
*/
public function query_ads($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_ads as id,b.name_ads as name,b.description_ads as description,b.link_ads as link,b.image_ads as image,s.status_name as status,s.status_color as color,sec.name_section as name_s,b.click_ads as click FROM ads as b INNER JOIN status as s ON (b.id_status=s.id_status) INNER JOIN sections as sec ON (b.id_section=sec.id_section) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_ads as id,b.name_ads as name,b.id_status as status,b.description_ads as description,b.link_ads as link,b.image_ads as image,b.id_section as seccion FROM ads as b WHERE b.id_ads='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de ads existe.
*
*Funcion para consultar nombre de ads registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de ads,Int $id del ads
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM ads WHERE name_ads='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM ads WHERE name_ads='$datos' AND id_ads !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Consulta de secciones.
*
* Consulta de secciones registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de secciones registrados
* @param Int $datos id del usuario
*/
public function query_sections($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_section as id,b.name_section as name FROM sections as b ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM sections as b WHERE b.id_section='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Registrar ads.
*
*Funcion para registrar ads*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la ads,String $doc ruc de la ads,String $direccion direccion de la ads,Int $status status de la ads
*/
public function register_ads($name,$seccion,$link,$descripcion,$imagen,$user){
    $date=date('Y-m-d H:i:s');
    $name_archivo = str_replace(" ", "_", $name);
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $insert=$this->db->query("INSERT INTO ads(name_ads,description_ads,link_ads,image_ads,id_section,id_user,create_date) VALUES ('$name','$descripcion','$link','$name_image','$seccion','$user','$date')");
    if ($insert) {
    $location=$_SESSION['ruta_img'].'ads_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    }
    return $insert;
}
/**
* Editar ads.
*
*Funcion para editar ads*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la ads,String $doc ruc de la ads,String $direccion direccion de la ads,Int $status status de la ads,Int $data1 id de ads
*/
public function edit_ads($name,$seccion,$link,$descripcion,$imagen,$status,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE ads SET name_ads='$name',description_ads='$descripcion',link_ads='$link',id_section='$seccion',id_status='$status',id_user='$user',create_date='$date' WHERE id_ads='$id'");
    $name_archivo = str_replace(" ", "_", $name);
    if (!is_null($imagen)) {
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $location=$_SESSION['ruta_img'].'ads_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    $update=$this->db->query("UPDATE ads SET image_ads='$name_image' WHERE id_ads='$id'");
    }
    return $update;
}
/**
* Chequear si ads.
*
*Funcion para validar si ads existe*
*
* @return Boolean  
* @param Int $id id de ads
*/
public function check_ads($id){
    $consulta=$this->db->query("SELECT 1 FROM ads WHERE id_ads='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Eliminar ads.
*
*Funcion para eliminar ads*
*
* @return Boolean  
* @param Int $id id de ads
*/
public function delete_ads($id){
    $delete=$this->db->query("DELETE FROM ads WHERE id_ads='$id'");
    if ($delete) {
    $nombre=$this->query_ads($id);
    $nombre=$nombre['image'];
    $location=$_SESSION['ruta_img'].'ads_img/'.$nombre;
    unlink($location);
    }
    return $delete;
}

}
?>