  <?php
  session_start();
  ?>
  <script>

    $(function () {
//ready
const Toast = Swal.mixin({
  toast: true,
  position: 'top-end',
  showConfirmButton: false,
  timer: 3000
});
$(document).ready(function(e) {

});
//Initialize Datatable

//Tabla de usuarios//
var wp_table = $("#list_users").DataTable({
  responsive: {
    details: {
      type: 'column'
    }
  },
  columnDefs: [ {
    className: 'control',
    orderable: false,
    targets:   0
  } ],

  order: [ 1, 'asc' ],
  autoWidth: true,
  bProcessing: false,
  bServerSide: false,
  bInfo: false,
  columns: [
  { data: 'id' , render: function(data, type, row){
    return cel(data, row.id);
  }},
  { data: 'usuario' },
  { data: 'name' },
  { data: 'email' },
  { data: 'perfil' },
  { data: 'status' , render: function(data, type, row){
    return status(data, row.color);
  }},
  { data: 'id', render: function(data, type, row){
    return actions(data, row.id);
  }},
  ],
});
//Funcion para consultar datos de usarios y llenar tabla//
function dataTable_init() {
  data = {'option':'<?php echo $decryp->encryptroute('view/users/query_users')?>'};
  $.post('../core/process.php', data)
  .done(function(resp){
   wp_table = $("#list_users").DataTable();
   wp_table.clear();
   $.each(resp.datos, function (k, v) {
    wp_table.row.add(v);
  });
   wp_table.draw();
     //wp_table.columns.adjust().responsive.recalc();
   }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
 }
//Funcion para columna nombre//
function name(wpid, wpactive) {
  var name=wpid+' '+wpactive; 
  return name;
}
//Funcion status//
function status(wpid, wpactive) {
  var status='<span class="badge badge-'+wpactive+'">'+wpid+'</span>'; 
  actions_cell = status;
  return actions_cell;
}
//Funcion para botones de accion//
function actions(wpid, wpactive) {
  actions_cell = '<button class="btn btn-primary edit_cat" data-data1="' + wpid + '" ><i class="fas fa-pencil-alt"></i></button> <button class="btn btn-danger delete" data-data1="' + wpid + '" ><i class="fa fa fa-trash"></i></button> <button class="btn btn-warning edit_password" data-data1="' + wpid + '" ><i class="fas fa-key"></i></button>';

  return actions_cell;
}
//Campo vacio para responsive//
function cel(wpid, wpactive) {
  actions_cell = '';
  return actions_cell;
}
dataTable_init();
//Abrir modal de usuarios para registrar//
$(document).on('click', '#add_modal', function(e){
  data = {'option':'<?php echo $decryp->encryptroute('add/N')?>'};
  $.post('../core/process.php', data)
  .done(function(resp){
   $('#addcat').modal('show'); 
   $('#addcat form').trigger('reset'); 
   $('#title_modal').html('Agregar Usuario <?php echo$_SESSION['lang']['REQUERIDOS']?>');
   $('#edit').hide();
   $('#save').show();
   $( "#status" ).prop( "checked", true );
   $('#sts').hide();
   $(".view_clave").show();
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   $('#addcat').modal('hide'); 
   toastr.error(resp.msg);
 }
});


});
//Funcion para registrar usuarios//
$(document).on('click', '#save', function(e){
  submit('#save');
  var perfil = $("#perfil").val();
  var usuario = $("#usuario").val();
  var nombre = $("#nombre").val();
  var clave = $("#clave_user").val();
  var email = $("#email").val();

  if (typeof nombre == 'undefined' || nombre === null || nombre === '' || typeof usuario == 'undefined' || usuario === null || usuario === '' || typeof perfil == 'undefined' || perfil === null || perfil === '' || typeof clave == 'undefined' || clave === null || clave === '' || typeof email == 'undefined' || email === null || email === '' ) {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#save');
 }else {
  data = {'option':'<?php echo $decryp->encryptroute('add/users/register_user')?>','perfil':perfil,'nombre':nombre,'usuario':usuario,'clave':clave,'email':email};
  $.post('../core/process.php', data)
  .done(function(resp){
   $('#addcat').modal('hide'); 
   toastr.success(resp.msg);
   dataTable_init();
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   //$('#addcat').modal('hide'); 
   toastr.error(resp.msg);
 }
}).always( function() {
  finish('#save');
});
}
});
//Funcion para obtener datos de usuario por id. Llenar el modal//
$(document).on('click', '.edit_cat', function(e){
  var data1 = $(this).data('data1');
  if (typeof data1 == 'undefined' || data1 === null || data1 === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  } else {
    data = {'option':'<?php echo $decryp->encryptroute('edit/users/view_user')?>','data1':data1};
    $.post('../core/process.php', data)
    .done(function(resp){
      $('#addcat form').trigger('reset'); 
      $('#addcat').modal('show'); 
      $('#edit').show();
      $('#save').hide();
      $('#sts').show();
      $(".view_clave").hide();
      $('#title_modal').html('Editar Usuario <?php echo $_SESSION['lang']['REQUERIDOS']?>');
      $.each(resp.datos, function (k, v) {
        $('#id').val(v.id);
        $('#perfil').val(v.perfil);
        $('#nombre').val(v.name);
        $('#usuario').val(v.usuario);
        $('#email').val(v.email);
        if (v.status == '1') {
          $( "#status" ).prop( "checked", true );
        }else{
          $( "#status" ).prop( "checked", false );
        }
      });
    }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
  }
});
//Funcion editar datos de usuario//
$(document).on('click', '#edit', function(e){
  submit('#edit');
  var id = $("#id").val();
  var status=$("#status").is(':checked') ? 1 : 2;
  var perfil = $("#perfil").val();
  var usuario = $("#usuario").val();
  var nombre = $("#nombre").val();
  var email = $("#email").val();

  if (typeof nombre == 'undefined' || nombre === null || nombre === '' || typeof usuario == 'undefined' || usuario === null || usuario === '' || typeof perfil == 'undefined' || perfil === null || perfil === '' || typeof id == 'undefined' || id === null || id === '' || typeof status == 'undefined' || status === null || status === '' || typeof email == 'undefined' || email === null || email === '') { 
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#edit');
 }else {
  data = {'option':'<?php echo $decryp->encryptroute('edit/users/edit_user')?>','perfil':perfil,'nombre':nombre,'usuario':usuario,'status':status,'id':id,'email':email};
  $.post('../core/process.php', data)
  .done(function(resp){
   $('#addcat').modal('hide'); 
   toastr.success(resp.msg);
   dataTable_init();
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   //$('#addcat').modal('hide'); 
   toastr.error(resp.msg);
 }
}).always( function() {
  finish('#edit');
});
}
});
//Abrir modal para editar clave//
$(document).on('click', '.edit_password', function(e){
  e.preventDefault();
  var data1 = $(this).data('data1');
  data = {'option':'<?php echo $decryp->encryptroute('edit/N')?>'};
  $.post('../core/process.php', data)
  .done(function(resp){
   $('#edit-password').modal('show'); 
   $('#edit-password form').trigger('reset'); 
   if (typeof data1 == 'undefined' || data1 === null || data1 === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  }else {
    $('#id1').val(data1);
  }
}).fail( function(jqXHR, textStatus, errorThrown) {
 var resp=jqXHR.responseJSON;
 var status=jqXHR.status;
 if(status == 401){
  toastr.error(resp.msg);
  logout();
}else{
 toastr.error(resp.msg);
}
});
});
//Funcion editar clave//
$(document).on('click', '#edit_pass', function(e){
  e.preventDefault();
  submit('#edit_pass');
  var id = $("#id1").val();
  var clave = $("#pass").val();
  if (typeof id == 'undefined' || id === null || id === '' || typeof clave == 'undefined' || clave === null || clave === '' ) {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#edit_pass');
 }else {
  data = {'option':'<?php echo $decryp->encryptroute('edit/users/edit_password')?>','clave':clave,'id':id};
  $.post('../core/process.php', data)
  .done(function(resp){
    $('#edit-password').modal('hide'); 
    toastr.success(resp.msg);
    dataTable_init();
  }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   //$('#addcat').modal('hide'); 
   toastr.error(resp.msg);
 }
}).always( function() {
  finish('#edit_pass');
});

}
});
//Funcion abrir modal para eliminar Producto// 
$(document).on('click', '.delete', function(e){
  var data1 = $(this).data('data1');
  $( '#delete_cat' ).data( 'data1', data1);
  $('#modal_eliminar').modal('show'); 
});
//Funcion eliminar Producto// 
$(document).on('click', '#delete_cat', function(e){
  submit('#delete_cat');
  var data1 = $(this).data('data1');
  if (typeof data1 == 'undefined' || data1 === null || data1 === '') {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#delete_cat');
   $('#modal_eliminar').modal('hide'); 
 } else {
  data = {'option':'<?php echo $decryp->encryptroute('delete/users/delete_user')?>','id':data1};
  $.post('../core/process.php', data)
  .done(function(resp){
   toastr.success(resp.msg);
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg); 
 }
}).always( function() {
  $('#modal_eliminar').modal('hide');
  finish('#delete_cat');
  dataTable_init();
});
}
});
//End//
});
</script>