  <?php
  session_start();
  ?>
  <script>

    $(function () {
//ready
$('.select2').select2();
$('.select2bs4').select2({
  theme: 'bootstrap4'
});
$("#precio").maskMoney({allowNegative: true, thousands:'.', decimal:',', affixesStay: false});
$("#agencias_master").maskMoney({allowNegative: true, thousands:'.', decimal:',', affixesStay: false});
$("#superagencia").maskMoney({allowNegative: true, thousands:'.', decimal:',', affixesStay: false});
$("#asesores").maskMoney({allowNegative: true, thousands:'.', decimal:',', affixesStay: false});

const formatterDolar = new Intl.NumberFormat('es-VE', {
 style: 'currency',
 currency: 'BSF'
});
$('#descripcion').summernote();
const Toast = Swal.mixin({
  toast: true,
  position: 'top-end',
  showConfirmButton: false,
  timer: 3000
});
$(document).ready(function(e) {
});
var wp_table = $("#list_products").DataTable({
  responsive: {
    details: {
      type: 'column'
    }
  },
  columnDefs: [ {
    className: 'control',
    orderable: false,
    targets:   0
  } ],
  order: [ 1, 'asc' ],
  autoWidth: true,
  bProcessing: false,
  bServerSide: false,
  bInfo: false,
  columns: [
  { data: 'id' , render: function(data, type, row){
    return cel(data, row.id);
  }},
  { data: 'name'},
  { data: 'web'},
  { data: 'precio'},
  { data: 'formulario'},
  { data: 'superagencia'},
  { data: 'agencias_master'},
  { data: 'asesores'},
  { data: 'status' , render: function(data, type, row){
    return status(data, row.color);
  }},
  { data: 'id', render: function(data, type, row){
    return actions(data,row.image,row.license);
  }},
  ],
});
//Funcion para consultar datos de usarios y llenar tabla//
function dataTable_init() {
  data = {'option':'<?php echo $decryp->encryptroute('view/products/query_products')?>'};
  $.post('<?php echo $url_admin;?>core/process.php', data)
  .done(function(resp){
   wp_table = $("#list_products").DataTable();
   wp_table.clear();
   $.each(resp.datos, function (k, v) {
    wp_table.row.add(v);
  });
   wp_table.draw();
   wp_table.columns.adjust().responsive.recalc();
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg);
 }
});
}
//Funcion status//
function status(wpid, wpactive) {
  var status='<span class="badge badge-'+wpactive+'">'+wpid+'</span>'; 
  actions_cell = status;
  return actions_cell;
}

//Funcion para columna nombre//
function img_table(wpid, wpactive) {
  var name='<img src="<?php echo $url_admin;?>dist/products_img/'+wpid+ '?' + Math.random()+ '" style="width: 100%; height: 100px;">'; 
  return name;
}
//Funcion para botones de accion//
function actions(wpid,img,pdf) {
  actions_cell = '<button class="btn btn-primary edit_cat" data-data1="' + wpid + '" ><i class="fas fa-pencil-alt"></i></button> <button class="btn btn-danger delete" data-data1="' + wpid + '" ><i class="fa fa fa-trash"></i></button> <button class="btn btn-info view_detail" data-data1="' + wpid + '" ><i class="fas fa-eye"></i></button>';
  return actions_cell;
}
//Campo vacio para responsive//
function cel(wpid, wpactive) {
  actions_cell = '';
  return actions_cell;
}

dataTable_init();

function readURL(input) {
  if (input.files && input.files[0]) {
    var reader = new FileReader();
    reader.onload = function(e) {
      // Asignamos el atributo src a la tag de imagen
      $('#imagenmuestra').attr('src', e.target.result);
    }
    reader.readAsDataURL(input.files[0]);
  }
}
// El listener va asignado al input
$(document).on('change', '#imagen', function(e){
  readURL(this);
});
//Detalles de propiedad//
$(document).on('click', '.view_detail', function(e){
  var id = $(this).data('data1');
  if (typeof id == 'undefined' || id === null || id === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  } else {
    data = {'option':'<?php echo $decryp->encryptroute('view_/products/view_product')?>','id':id};
    $.post('<?php echo $url_admin;?>core/process.php', data)
    .done(function(resp){ 
      $('#datails').modal('show'); 
      $.each(resp.datos, function (k, v) {
        var precio=(formatterDolar.format(v.precio));
        var precio=precio.replace('BSF', '')
        $('#nombre_det').html(v.name);
        $('#precio_det').html(precio);
        $('#form_det').html(v.formulario);
        $('#descripcion_det').html('<label>Descripcion</label><br> '+v.description);
        $('#imagen_detalle').attr('src', '<?php echo $url_admin;?>dist/products_img/'+v.image+ '?' + Math.random());
      });
      $('#det_archivos').html('<label>Archivos</label><br>');
      $.each(resp.archivos, function (a, b) {
        $('#det_archivos').append('<a target="_blank" href="<?php echo $url_admin;?>dist/downloadable_files/'+b.url+'">'+b.name+'</a> ');
      });
    }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
  }
});
//Eliminar item a plan//
function formularios(){
  data = {'option':'<?php echo $decryp->encryptroute('view/products/query_insurances')?>'};
  $.post('../core/process.php', data)
  .done(function(resp){
    $('.select2').empty().append(new Option('Seleccione',''));
    $.each(resp.datos, function (k, v) {
      $('.select2').append(new Option(v.name,v.id));
    });
  }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg);
 }
});
}
//Eliminar item a plan//
function archivos(){
  data = {'option':'<?php echo $decryp->encryptroute('view/products/query_downloadable_files')?>'};
  $.post('../core/process.php', data)
  .done(function(resp){
    $('.archivos').empty();
    $.each(resp.datos, function (k, v) {
      $('.archivos').append(new Option(v.name,v.id));
    });
  }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg);
 }
});
}
archivos();
formularios();
//Abrir modal de propiedades para registrar//
$(document).on('click', '#add_modal', function(e){
  data = {'option':'<?php echo $decryp->encryptroute('add/N')?>'};
  $.post('../core/process.php', data)
  .done(function(resp){
    $('#addcat').modal('show'); 
    $('#addcat form').trigger('reset'); 
    $('#title_modal').html('Agregar Producto <?php echo$_SESSION['lang']['REQUERIDOS']?> ');
    $('#edit').hide();
    $('#save').show();
    $( "#status" ).prop( "checked", true );
    $( "#web" ).prop( "checked", false );

    $('#sts').hide();
    $('#precio').maskMoney('mask', 0.00);  
    $("#descripcion").summernote('reset');
    $('#imagenmuestra').attr('src', '');
    $('#formulario').val('');
    $('#formulario').select2().trigger('change');
    $('.archivos').val('');
    $('.archivos').select2().trigger('change');
  }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   $('#addcat').modal('hide'); 
   toastr.error(resp.msg);
 }
});
});


//Funcion para registrar propiedades//
$(document).on('click', '#save', function(e){
  submit('#save');
  var name =$('#name').val();
  var archivos=[];
  $(".archivos").each(function() {
   archivos=$(this).val();
 });
  var formulario =$('#formulario').val();
  var precio = $("#precio").val();
  var descripcion = $("#descripcion").summernote('code');
  var imagen = $("#imagen")[0].files[0];
  var agencias_master =$('#agencias_master').val();
  var asesores =$('#asesores').val();
  var superagencia =$('#superagencia').val();
  var web=$("#web").is(':checked') ? 2 : 1;

  if (typeof name == 'undefined' || name === null || name === '' || typeof formulario == 'undefined' || formulario === null || formulario === '' || typeof descripcion == 'undefined' || descripcion === null || descripcion === '' || typeof imagen == 'undefined' || imagen === null || imagen === '' || typeof agencias_master == 'undefined' || agencias_master === null || agencias_master === '' || typeof asesores == 'undefined' || asesores === null || asesores === '' || typeof superagencia == 'undefined' || superagencia === null || superagencia === '' || typeof web == 'undefined' || web === null || web === '') {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#save');
 }else {
  var nuevo = new FormData();
  nuevo.append('option','<?php echo $decryp->encryptroute('add/products/register_product')?>');
  nuevo.append('name',name);
  nuevo.append('precio',precio);
  nuevo.append('formulario',formulario);
  nuevo.append('agencias_master',agencias_master);
  nuevo.append('asesores',asesores);
  nuevo.append('web',web);
  nuevo.append('superagencia',superagencia);
  for (var i = 0; i < archivos.length; i++) {
    nuevo.append('archivos[]', archivos[i]);
  }
  nuevo.append('descripcion',descripcion);
  nuevo.append('imagen',imagen);
  $.ajax({
    url: "<?php echo $url_admin;?>core/process.php",
    dataType: 'json',
    type: "post",
    data: nuevo,
    cache: false,
    contentType: false,
    processData: false
  })
  .done(function(resp){
   $('#addcat').modal('hide'); 
   toastr.success(resp.msg);
   dataTable_init();
   formularios();
   $('#imagenmuestra').attr('src', '');
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg);
 }
}).always( function() {
  finish('#save');
});
}
});

//Detalles de propiedad//
$(document).on('click', '.edit_cat', function(e){
  var id = $(this).data('data1');
  if (typeof id == 'undefined' || id === null || id === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  } else {
    data = {'option':'<?php echo $decryp->encryptroute('view_/products/view_product')?>','id':id};
    $.post('<?php echo $url_admin;?>core/process.php', data)
    .done(function(resp){ 
      $('#addcat form').trigger('reset'); 
      $('#addcat').modal('show'); 
      $('#edit').show();
      $('#save').hide();
      $('#sts').show();
      $('#precio').maskMoney('mask', 0.00); 
      $('#superagencia').maskMoney('mask', 0.00);  
      $('#agencias_master').maskMoney('mask', 0.00);  
      $('#asesores').maskMoney('mask', 0.00);  

      $("#descripcion").summernote('reset');
      $('#imagenmuestra').attr('src', '');
      $('.archivos option').attr('selected',false);
      $('.archivos').select2().trigger('change');
      $('#title_modal').html('Editar Producto <?php echo $_SESSION['lang']['REQUERIDOS']?>');
      $.each(resp.datos, function (k, v) {
        $('#id_opr').val(v.id);
        $('#name').val(v.name);
        $('#precio').maskMoney('mask', parseFloat(v.precio, 10));
        $('#descripcion').summernote('code', v.description);
        $('#imagenmuestra').attr('src', '<?php echo $url_admin;?>dist/products_img/'+v.image+ '?' + Math.random());
        $('#formulario').val(v.id_formulario);
        $('#formulario').select2().trigger('change');

        $('#superagencia').maskMoney('mask', parseFloat(v.superagencia, 10));
        $('#agencias_master').maskMoney('mask', parseFloat(v.agencias_master, 10));
        $('#asesores').maskMoney('mask', parseFloat(v.asesores, 10));

        if (v.web == '2') {
          $( "#web" ).prop( "checked", true );
        }else{
          $( "#web" ).prop( "checked", false );
        }

        if (v.status == '1') {
          $( "#status" ).prop( "checked", true );
        }else{
          $( "#status" ).prop( "checked", false );
        }
      });
      $.each(resp.archivos, function (a, b) {
        $('.archivos option[value='+b.id+']').attr('selected','selected');
        $('.archivos').select2().trigger('change');
      });
    }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
  }
});
//Funcion para registrar propiedades//
$(document).on('click', '#edit', function(e){
  submit('#edit');
  var id = $("#id_opr").val();
  var name =$('#name').val();
  var precio = $("#precio").val();
  var descripcion = $("#descripcion").summernote('code');
  var status=$("#status").is(':checked') ? 1 : 2;
  var imagen = $("#imagen")[0].files[0];
  var archivos=[];
  $(".archivos").each(function() {
   archivos=$(this).val();
 });
  var web=$("#web").is(':checked') ? 2 : 1;

  var formulario =$('#formulario').val();
  var superagencia =$('#superagencia').val();
  var agencias_master =$('#agencias_master').val();
  var asesores =$('#asesores').val();
  if (typeof name == 'undefined' || name === null || name === '' || typeof descripcion == 'undefined' || descripcion === null || descripcion === '' || typeof status == 'undefined' || status === null || status === '' || typeof id == 'undefined' || id === null || id === '' || typeof formulario == 'undefined' || formulario === null || formulario === '' || typeof agencias_master == 'undefined' || agencias_master === null || agencias_master === '' || typeof asesores == 'undefined' || asesores === null || asesores === ''  || typeof superagencia == 'undefined' || superagencia === null || superagencia === '' || typeof web == 'undefined' || web === null || web === '') {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#edit');
 }else {
  var nuevo = new FormData();
  nuevo.append('option','<?php echo $decryp->encryptroute('edit/products/edit_product')?>');
  nuevo.append('id',id);
  nuevo.append('status',status);
  nuevo.append('name',name);
  nuevo.append('precio',precio);
  nuevo.append('descripcion',descripcion);
  nuevo.append('formulario',formulario);
  nuevo.append('superagencia',superagencia);
  nuevo.append('agencias_master',agencias_master);
  nuevo.append('asesores',asesores);
  nuevo.append('web',web);

  for (var i = 0; i < archivos.length; i++) {
    nuevo.append('archivos[]', archivos[i]);
  }
  nuevo.append('imagen',imagen);
  $.ajax({
    url: "<?php echo $url_admin;?>core/process.php",
    dataType: 'json',
    type: "post",
    data: nuevo,
    cache: false,
    contentType: false,
    processData: false
  })
  .done(function(resp){
   $('#addcat').modal('hide'); 
   toastr.success(resp.msg);
   dataTable_init();
   $('#imagenmuestra').attr('src', '');
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg);
 }
}).always( function() {
  finish('#edit');
});
}
});
//Funcion abrir modal para eliminar Producto// 
$(document).on('click', '.delete', function(e){
  var data1 = $(this).data('data1');
  $( '#delete_cat' ).data( 'data1', data1);
  $('#modal_eliminar').modal('show'); 
});
//Funcion eliminar Producto// 
$(document).on('click', '#delete_cat', function(e){
  submit('#delete_cat');
  var data1 = $(this).data('data1');
  if (typeof data1 == 'undefined' || data1 === null || data1 === '') {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#delete_cat');
   $('#modal_eliminar').modal('hide'); 
 } else {
  data = {'option':'<?php echo $decryp->encryptroute('delete/products/delete_product')?>','id':data1};
  $.post('<?php echo $url_admin;?>core/process.php', data)
  .done(function(resp){
   toastr.success(resp.msg);
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg); 
 }
}).always( function() {
  $('#modal_eliminar').modal('hide');
  finish('#delete_cat');
  dataTable_init();
});
}
});
$(document).on('input', '.input-number', function(e){
this.value = (this.value + '').replace(/[^0-9]/g, '');
});

//END//
});
</script>