  <?php
  session_start();
  ?>
  <script>

    $(function () {
const Toast = Swal.mixin({
  toast: true,
  position: 'top-end',
  showConfirmButton: false,
  timer: 3000
});
$(document).ready(function(e) {
  $('#filtercam').hide();
  $('#list_campaigns_filter').append('<button class="btn btn-primary" id="addfilter"><i class="fas fa-filter"></i></button>');
});
//Tabla de filtros//
var wp_filter = $("#filter").DataTable({
 searching: false,
 paging: false,
 ordering:  false,
 responsive: {
  details: {
    type: 'column'
  }
},
columnDefs: [ {
  className: 'control',
  orderable: false,
  targets:   0
} ],
autoWidth: true,
bProcessing: false,
bServerSide: false,
bInfo: false,
});
var wp_table = $("#list_campaigns").DataTable({
  responsive: {
    details: {
      type: 'column'
    }
  },
  columnDefs: [ {
    className: 'control',
    orderable: false,
    targets:   0
  } ],
  //order: [ 1, 'desc' ],
  autoWidth: true,
  bProcessing: false,
  bServerSide: false,
  bInfo: false,
  columns: [
  { data: 'id' , render: function(data, type, row){
    return cel(data, row.id);
  }},
  { data: 'fecha_inicio'},
  { data: 'fecha_fin'},
  { data: 'name'},
  { data: 'usuario'},
  { data: 'listas' , render: function(data, type, row){
    return listas_d(data, row.listas);
  }},
  { data: 'status' , render: function(data, type, row){
    return status(data, row.color);
  }},
  { data: 'id', render: function(data, type, row){
    return actions(data,row.id_status);
  }},
  ],
});
//Funcion para consultar datos de usarios y llenar tabla//
function dataTable_init() {
  data = {'option':'<?php echo $decryp->encryptroute('view/campaigns_push/query_campaigns_push')?>'};
  $.post('<?php echo $url_admin;?>core/process.php', data)
  .done(function(resp){
   wp_table = $("#list_campaigns").DataTable();
   wp_table.clear();
   $.each(resp.datos, function (k, v) {
    wp_table.row.add(v);
  });
   wp_table.draw();
   wp_table.columns.adjust().responsive.recalc();
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg);
 }
});
}
//Funcion status//
function status(wpid, wpactive) {
  var status='<span class="badge badge-'+wpactive+'">'+wpid+'</span>'; 
  actions_cell = status;
  return actions_cell;
}
//Funcion etiqueta//
function listas_d(wpid, wpactive) {
  var x='';
  var y=wpid.length;
  var n=1;
  $.each(wpid, function (k, v) {
    var b=(y==n)?'':'-';
    x+='<span class="badge badge-info">'+v.name+'</span>'+b;
    n++;
  });
  return x;
}
//Funcion para botones de accion//
function actions(wpid,status) {
  if (status == "3") {
  actions_cell = '<button class="btn btn-info view_detail" data-data1="' + wpid + '" title="Detalles de la campaña" ><i class="fas fa-eye"></i></button> <button class="btn btn-warning duplicate" data-data1="' + wpid + '" title="Duplicar"><i class="fa fa-clone"></i></button>';
  }else{
  actions_cell = '<button class="btn btn-primary edit_cat" data-data1="' + wpid + '" title="Editar" ><i class="fas fa-pencil-alt"></i></button> <button title="Eliminar" class="btn btn-danger delete" data-data1="' + wpid + '" ><i class="fa fa fa-trash"></i></button> <button title="Detalles de la campaña" class="btn btn-info view_detail" data-data1="' + wpid + '" ><i class="fas fa-eye"></i></button> <button class="btn btn-warning duplicate" data-data1="' + wpid + '" title="Duplicar"><i class="fa fa-clone"></i></button> <button class="btn btn-success statistics" data-data1="' + wpid + '" title="Estadisticas"><i class="fas fa-chart-line"></i></button>';
  }
  if (status == "7") {
  actions_cell += ' <button class="btn btn-success aprobar" data-data1="' + wpid + '" title="Aprobar" ><i class="fas fa-check-double"></i></button>';

  }
  return actions_cell;
}
//Campo vacio para responsive//
function cel(wpid, wpactive) {
  actions_cell = '';
  return actions_cell;
}

dataTable_init();

//Funcion para buscar datos por columnas//
function filterColumn (i) {
 wp_table
 .columns( i )
 .search($('#col'+i+'_filter').val(), true, false)
 .draw();
}
$('input.column_filter').on( 'keyup', function () {
  var data=$(this).data('column');
  filterColumn($(this).data('column'));
} );
$('#col6_filter').on( 'change', function () {
  filterColumn($(this).data('column'));
} );
$('#col1_filter').on( 'change', function () {
  filterColumn($(this).data('column'));
} );
$('#col2_filter').on( 'change', function () {
  filterColumn($(this).data('column'));
} );
//Funcion abrir seccion filtros //
$(document).on('click', '#addfilter', function(e){
  $('#filtercam').show();
  $("#addfilter").remove();
  $('#list_campaigns_filter').append(' <button class="btn btn-danger" id="closefilter"><i class="fas fa-window-close"></i></button>');
});
//Funcion cerrar seccion filtros//
$(document).on('click', '#closefilter', function(e){
  $('#filtercam').hide();
  $("#closefilter").remove();
  $('#list_campaigns_filter').append(' <button class="btn btn-primary" id="addfilter"><i class="fas fa-filter"></i></button>');
});
//Abrir modal de propiedades para registrar//
$(document).on('click', '#add_modal', function(e){
      var newWindow = window.open("","_self");
      var url="<?php echo $url_admin;?>";
      newWindow.location.href =url+'campanas_push/enviar/';
});

// Editar//
$(document).on('click', '.edit_cat', function(e){
  var id = $(this).data('data1');
  if (typeof id == 'undefined' || id === null || id === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  } else {
    data = {'option':'<?php echo $decryp->encryptroute('edit/campaigns_push/view_campaigns_push')?>','id':id};
    $.post('<?php echo $url_admin;?>core/process.php', data)
    .done(function(resp){
      var newWindow = window.open("","_self");
      var url="<?php echo $url_admin;?>";
      newWindow.location.href =url+'campanas_push/editar/'+id+'/';
    }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
  }
});
//Funcion abrir modal para eliminar Producto// 
$(document).on('click', '.view_detail', function(e){

  var id = $(this).data('data1');
  if (typeof id == 'undefined' || id === null || id === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  } else {
    data = {'option':'<?php echo $decryp->encryptroute('edit/campaigns_push/view_campaigns_push')?>','id':id};
    $.post('<?php echo $url_admin;?>core/process.php', data)
    .done(function(resp){
      var newWindow = window.open("","_self");
      var url="<?php echo $url_admin;?>";
      newWindow.location.href =url+'campanas_push/detalles/'+id+'/';
    }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
  }

});
//Funcion abrir modal para eliminar Producto// 
$(document).on('click', '.duplicate', function(e){
  var data1 = $(this).data('data1');
  $( '#duplicate_cat' ).data( 'data1', data1);
  $('#modal_duplicate').modal('show'); 
});
//Funcion eliminar Producto// 
$(document).on('click', '#duplicate_cat', function(e){
  submit('#duplicate_cat');
  var data1 = $(this).data('data1');
  if (typeof data1 == 'undefined' || data1 === null || data1 === '') {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#duplicate_cat');
   $('#modal_duplicate').modal('hide'); 
 } else {
  data = {'option':'<?php echo $decryp->encryptroute('add/campaigns_push/duplicate_campaigns_push')?>','id':data1};
  $.post('<?php echo $url_admin;?>core/process.php', data)
  .done(function(resp){
   toastr.success(resp.msg);
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg); 
 }
}).always( function() {
  $('#modal_duplicate').modal('hide');
  finish('#duplicate_cat');
  dataTable_init();
});
}
});
//Funcion abrir modal para eliminar Producto// 
$(document).on('click', '.delete', function(e){
  var data1 = $(this).data('data1');
  $( '#delete_cat' ).data( 'data1', data1);
  $('#modal_eliminar').modal('show'); 
});
//Funcion eliminar Producto// 
$(document).on('click', '#delete_cat', function(e){
  submit('#delete_cat');
  var data1 = $(this).data('data1');
  if (typeof data1 == 'undefined' || data1 === null || data1 === '') {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#delete_cat');
   $('#modal_eliminar').modal('hide'); 
 } else {
  data = {'option':'<?php echo $decryp->encryptroute('delete/campaigns_push/delete_campaigns_push')?>','id':data1};
  $.post('<?php echo $url_admin;?>core/process.php', data)
  .done(function(resp){
   toastr.success(resp.msg);
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg); 
 }
}).always( function() {
  $('#modal_eliminar').modal('hide');
  finish('#delete_cat');
  dataTable_init();
});
}
});
//Funcion abrir modal para eliminar Producto// 
$(document).on('click', '.statistics', function(e){
  var id = $(this).data('data1');
  if (typeof id == 'undefined' || id === null || id === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  } else {
    data = {'option':'<?php echo $decryp->encryptroute('edit/campaigns_push/view_campaigns_push')?>','id':id};
    $.post('<?php echo $url_admin;?>core/process.php', data)
    .done(function(resp){
      var newWindow = window.open("","_self");
      var url="<?php echo $url_admin;?>";
      newWindow.location.href =url+'campanas_push/estadisticas/'+id+'/';
    }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
  }

});
//END//
});
</script>