  <?php
  session_start();
  ?>
  <script>

    $(function () {
//ready

const Toast = Swal.mixin({
  toast: true,
  position: 'top-end',
  showConfirmButton: false,
  timer: 3000
});
$(document).ready(function(e) {
});
var wp_table = $("#list_banners").DataTable({
  responsive: {
    details: {
      type: 'column'
    }
  },
  columnDefs: [ {
    className: 'control',
    orderable: false,
    targets:   0
  } ],
  order: [ 1, 'asc' ],
  autoWidth: true,
  bProcessing: false,
  bServerSide: false,
  bInfo: false,
  columns: [
  { data: 'id' , render: function(data, type, row){
    return cel(data, row.id);
  }},
  { data: 'image' , render: function(data, type, row){
    return img_table(data);
  }},
  { data: 'name'},
  { data: 'link'},
  { data: 'description'},
  { data: 'status' , render: function(data, type, row){
    return status(data, row.color);
  }},
  { data: 'id', render: function(data, type, row){
    return actions(data,row.image,row.license);
  }},
  ],
});
//Funcion para consultar datos de usarios y llenar tabla//
function dataTable_init() {
  data = {'option':'<?php echo $decryp->encryptroute('view/banners/query_banners')?>'};
  $.post('<?php echo $url_admin;?>core/process.php', data)
  .done(function(resp){
     wp_table = $("#list_banners").DataTable();
     wp_table.clear();
     $.each(resp.datos, function (k, v) {
      wp_table.row.add(v);
    });
     wp_table.draw();
     wp_table.columns.adjust().responsive.recalc();
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg);
 }
});
}
//Funcion status//
function status(wpid, wpactive) {
  var status='<span class="badge badge-'+wpactive+'">'+wpid+'</span>'; 
  actions_cell = status;
  return actions_cell;
}

//Funcion para columna nombre//
function img_table(wpid) {
  var name='<a href="#" class="view_logo" data-data1="' + wpid + '" ><img src="<?php echo $url_admin;?>dist/banners_img/'+wpid+ '?' + Math.random()+ '" style="width: 100%; height: 100px;"></a>'; 
  return name;
}
//Funcion para botones de accion//
function actions(wpid,img,pdf) {
  actions_cell = '<button class="btn btn-primary edit_cat" data-data1="' + wpid + '" ><i class="fas fa-pencil-alt"></i></button> <button class="btn btn-danger delete" data-data1="' + wpid + '" ><i class="fa fa fa-trash"></i></button>';
  return actions_cell;
}
//Campo vacio para responsive//
function cel(wpid, wpactive) {
  actions_cell = '';
  return actions_cell;
}

dataTable_init();

function readURL(input) {
  if (input.files && input.files[0]) {
    var reader = new FileReader();
    reader.onload = function(e) {
      // Asignamos el atributo src a la tag de imagen
      $('#imagenmuestra').attr('src', e.target.result);
    }
    reader.readAsDataURL(input.files[0]);
  }
}
// El listener va asignado al input
$(document).on('change', '#imagen', function(e){
  readURL(this);
});
//Abrir modal de propiedades para registrar//
$(document).on('click', '#add_modal', function(e){
  data = {'option':'<?php echo $decryp->encryptroute('add/N')?>'};
  $.post('../core/process.php', data)
  .done(function(resp){
    $('#addcat').modal('show'); 
    $('#addcat form').trigger('reset'); 
    $('#title_modal').html('Agregar Banner <?php echo$_SESSION['lang']['REQUERIDOS']?> ');
    $('#edit').hide();
    $('#save').show();
    $( "#status" ).prop( "checked", true );
    $('#sts').hide();
    $('#imagenmuestra').attr('src', '');
  }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   $('#addcat').modal('hide'); 
   toastr.error(resp.msg);
 }
});
});


//Funcion para registrar propiedades//
$(document).on('click', '#save', function(e){
  submit('#save');
  var name =$('#name').val();
  var link = $("#link").val();
  var descripcion = $("#descripcion").val();
  var imagen = $("#imagen")[0].files[0];
  if (typeof name == 'undefined' || name === null || name === '' || typeof link == 'undefined' || link === null || link === '' || typeof descripcion == 'undefined' || descripcion === null || descripcion === '' || typeof imagen == 'undefined' || imagen === null || imagen === '') {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#save');
 }else {
  var nuevo = new FormData();
  nuevo.append('option','<?php echo $decryp->encryptroute('add/banners/register_banner')?>');
  nuevo.append('name',name);
  nuevo.append('link',link);
  nuevo.append('descripcion',descripcion);
  nuevo.append('imagen',imagen);
  $.ajax({
    url: "<?php echo $url_admin;?>core/process.php",
    dataType: 'json',
    type: "post",
    data: nuevo,
    cache: false,
    contentType: false,
    processData: false
  })
  .done(function(resp){
   $('#addcat').modal('hide'); 
   toastr.success(resp.msg);
   dataTable_init();
   $('#imagenmuestra').attr('src', '');
}).fail( function(jqXHR, textStatus, errorThrown) {
 var resp=jqXHR.responseJSON;
 var status=jqXHR.status;
 if(status == 401){
  toastr.error(resp.msg);
  logout();
}else{
   toastr.error(resp.msg);
 }
}).always( function() {
  finish('#save');
});
}
});

//Detalles de propiedad//
$(document).on('click', '.view_logo', function(e){
  var foto = $(this).data('data1');
  $('#imagenlogo').attr('src', '');
  $('#logo_view').modal('show'); 
  $('#imagenlogo').attr('src', '<?php echo $url_admin;?>dist/banners_img/'+foto+ '?' + Math.random());
});
//Detalles de propiedad//
$(document).on('click', '.edit_cat', function(e){
  var id = $(this).data('data1');
  if (typeof id == 'undefined' || id === null || id === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  } else {
    data = {'option':'<?php echo $decryp->encryptroute('view_/banners/view_banner')?>','id':id};
    $.post('<?php echo $url_admin;?>core/process.php', data)
    .done(function(resp){ 
      $('#addcat form').trigger('reset'); 
      $('#addcat').modal('show'); 
      $('#edit').show();
      $('#save').hide();
      $('#sts').show();
      $('#title_modal').html('Editar Banner <?php echo $_SESSION['lang']['REQUERIDOS']?>');
      $.each(resp.datos, function (k, v) {
        $('#id_opr').val(v.id);
        $('#name').val(v.name);
        $('#link').val(v.link);
        $('#descripcion').html(v.description);
        $('#imagenmuestra').attr('src', '<?php echo $url_admin;?>dist/banners_img/'+v.image+ '?' + Math.random());
        if (v.status == '1') {
          $( "#status" ).prop( "checked", true );
        }else{
          $( "#status" ).prop( "checked", false );
        }
      });
    }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
  }
});
//Funcion para registrar propiedades//
$(document).on('click', '#edit', function(e){
  submit('#edit');
  var id = $("#id_opr").val();
  var name =$('#name').val();
  var link = $("#link").val();
  var descripcion = $("#descripcion").val();
  var status=$("#status").is(':checked') ? 1 : 2;
  var imagen = $("#imagen")[0].files[0];
  if (typeof name == 'undefined' || name === null || name === '' || typeof link == 'undefined' || link === null || link === '' || typeof descripcion == 'undefined' || descripcion === null || descripcion === '' || typeof status == 'undefined' || status === null || status === '' || typeof id == 'undefined' || id === null || id === '' ) {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#edit');
 }else {
  var nuevo = new FormData();
  nuevo.append('option','<?php echo $decryp->encryptroute('edit/banners/edit_banner')?>');
  nuevo.append('id',id);
  nuevo.append('status',status);
  nuevo.append('name',name);
  nuevo.append('link',link);
  nuevo.append('descripcion',descripcion);
  nuevo.append('imagen',imagen);
  $.ajax({
    url: "<?php echo $url_admin;?>core/process.php",
    dataType: 'json',
    type: "post",
    data: nuevo,
    cache: false,
    contentType: false,
    processData: false
  })
  .done(function(resp){
   $('#addcat').modal('hide'); 
   toastr.success(resp.msg);
   dataTable_init();
   $('#imagenmuestra').attr('src', '');
}).fail( function(jqXHR, textStatus, errorThrown) {
 var resp=jqXHR.responseJSON;
 var status=jqXHR.status;
 if(status == 401){
  toastr.error(resp.msg);
  logout();
}else{
   toastr.error(resp.msg);
 }
}).always( function() {
  finish('#edit');
});
}
});
//Funcion abrir modal para eliminar Producto// 
$(document).on('click', '.delete', function(e){
  var data1 = $(this).data('data1');
  $( '#delete_cat' ).data( 'data1', data1);
  $('#modal_eliminar').modal('show'); 
});
//Funcion eliminar Producto// 
$(document).on('click', '#delete_cat', function(e){
  submit('#delete_cat');
  var data1 = $(this).data('data1');
  if (typeof data1 == 'undefined' || data1 === null || data1 === '') {  
   toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
   finish('#delete_cat');
   $('#modal_eliminar').modal('hide'); 
 } else {
  data = {'option':'<?php echo $decryp->encryptroute('delete/banners/delete_banner')?>','id':data1};
  $.post('<?php echo $url_admin;?>core/process.php', data)
  .done(function(resp){
   toastr.success(resp.msg);
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg); 
 }
}).always( function() {
  $('#modal_eliminar').modal('hide');
  finish('#delete_cat');
  dataTable_init();
});
}
});


//END//
});
</script>