<?php
//Llamada al modelo
require 'model/subscribers_model.php';

class subscribers_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_subscriber($identificacion,$name,$apellido,$email,$email_e,$type_a,$agente,$tlf,$fecha_nac,$sexo,$pais,$listas,$status,$id){
	$per=new subscribers_model();

	if (strlen($identificacion) > 50 ) {
		$datos = array('msg' => 'Identificacion no debe superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($name) > 100 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($apellido) > 100 || empty($apellido)) {
		$datos = array('msg' => 'Apellido no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		$datos = array('msg' => 'Email invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!empty($email_e)) {
	if (!filter_var($email_e, FILTER_VALIDATE_EMAIL)) {
		$datos = array('msg' => 'Email emergencia invalido','status' => false ,'code' => 400);
		return $datos;
	}
    }
	if (strlen($identificacion) > 50 ) {
		$datos = array('msg' => 'Identificacion no debe superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($type_a) > 1 ) {
		$datos = array('msg' => 'Tipo de agencia no de superar 1 caracter','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($tlf) > 50 ) {
		$datos = array('msg' => 'Telefono no debe superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!empty($sexo)) {
	if ($sexo != "F" & $sexo != "M") {
		$datos = array('msg' => 'Sexo invalido','status' => false ,'code' => 400);
		return $datos;
	}}
   	if (!empty($fecha_nac)) {
	$valid=$per->validateDate($fecha_nac);
	if (!$valid) {
		$datos = array('msg' => 'Fecha de nacimiento invalida','status' => false ,'code' => 400);
		return $datos;
	}}

	if (!is_array($listas) || count($listas) < 1) {
		$datos = array('msg' => 'Lista no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}

	foreach ($listas as $value) {
		$valid=$per->query_lists($value);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Lista no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!empty($pais)) {
	$valid=$per->query_countries($pais);
	if (count($valid) == 0) {
		$datos = array('msg' => 'Error! Pais no existe','status' => false ,'code' => 400);
		return $datos;
	}}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($id)) {
		$valid=$per->check_subscriber($id);
		if (!$valid) {
			$datos = array('msg' => 'Suscriptor no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de subscribers.
*
*Funcion para consultar subscribers registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_subscribers(){
	$per=new subscribers_model();
	$datos=$per->query_subscribers(NULL);
	foreach ($datos as &$value) {
		$datos2=$per->check_lists($value['id'],2);
		$value['listas']=(count($datos2) == 0) ? [] : $datos2;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de lista.
*
*Funcion para consultar lista registrados *
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_lists(){
	$per=new subscribers_model();
	$datos=$per->query_lists(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de paises.
*
*Funcion para consultar paises registrados *
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_countries(){
	$per=new subscribers_model();
	$datos=$per->query_countries(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_subscriber(){
	$per=new subscribers_model();
	$identificacion=$_POST['identificacion'];
	$name=$_POST['name'];
	$apellido=$_POST['apellido'];
	$email=$_POST['email'];
	$email_e=$_POST['email_e'];
	$type_a=$_POST['type_a'];
	$agente=$_POST['agente'];
	$tlf=$_POST['tlf'];
	$pais=$_POST['pais'];
	$fecha_nac=$_POST['fecha_nac'];
	$sexo=$_POST['sexo'];
	$listas=$_POST['listas'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_subscriber($identificacion,$name,$apellido,$email,$email_e,$type_a,$agente,$tlf,$fecha_nac,$sexo,$pais,$listas,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_subscriber($identificacion,$name,$apellido,$email,$email_e,$type_a,$agente,$tlf,$fecha_nac,$sexo,$pais,$listas,$status,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $datos;
	}
}
/**
* Vista de subscribers.
*
*Funcion para consultar subscribers registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de subscribers
*/
public function view_subscriber(){
	$var1=$_POST['id'];
	$per=new subscribers_model();
	$datos=$per->query_subscribers($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'listas' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'subscriber no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Detalle de subscribers.
*
*Funcion para consultar subscribers registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de subscribers
*/
public function details_subscribers(){
	$var1=$_POST['id'];
	$per=new subscribers_model();
	$datos=$per->details_subscribers($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'listas' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'subscriber no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar subscribers.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_subscriber(){
	$per=new subscribers_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$identificacion=$_POST['identificacion'];
	$name=$_POST['name'];
	$apellido=$_POST['apellido'];
	$email=$_POST['email'];
	$email_e=$_POST['email_e'];
	$type_a=$_POST['type_a'];
	$agente=$_POST['agente'];
	$tlf=$_POST['tlf'];
	$pais=$_POST['pais'];
	$fecha_nac=$_POST['fecha_nac'];
	$sexo=$_POST['sexo'];
	$listas=$_POST['listas'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_subscriber($identificacion,$name,$apellido,$email,$email_e,$type_a,$agente,$tlf,$fecha_nac,$sexo,$pais,$listas,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$listas_p1=$per->check_lists($id,1);
		$listas_p1=(count($listas_p1) == 0)? [] : $listas_p1;
		$agregar_p = array_diff($listas, $listas_p1);
		$eliminar_p = array_diff($listas_p1,$listas);
		$datos=$per->edit_subscriber($identificacion,$name,$apellido,$email,$email_e,$type_a,$agente,$tlf,$fecha_nac,$sexo,$pais,$listas,$status,$id,$user,$agregar_p,$eliminar_p);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_subscriber(){
	$per=new subscribers_model();
	$data1=$_POST['id'];
	$valid=$per->check_subscriber($data1);
	if (!$valid) {
		$datos = array('msg' => 'Suscriptor no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_subscriber($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => 'Error! Suscriptor posee acciones registardas solo puede inactivar','status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_air(){
	$per=new subscribers_model();
	$id=$_POST['id'];
	$valid=$per->check_subscriber($id);
	if (!$valid) {
		$datos = array('msg' => 'Suscriptor no existe','status' => false,'code' => 400);
		return $datos;
	}
	$fecha_e=$_POST['fecha_e'];
	$fecha = explode("-", $fecha_e);
	$fechai = date("Y-m-d", strtotime($fecha[0]));
	$fechaf = date("Y-m-d", strtotime($fecha[1]));
	$date1=date_create($fechai);
	$date2 = date_create($fechaf);
	$diff = $date1->diff($date2);
	$diff= $diff->format('%R%a');
	$diff = substr($diff, 0,1);
	if($diff == "-"){
		$datos = array('msg' => 'Error Fecha invalida','status' => 'F');
		return $datos;
	}
	$valid=$per->validateDate($fechai);
	if (!$valid) {
		$datos = array('msg' => 'Fecha de Vuelo invalida','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per->validateDate($fechaf);
	if (!$valid) {
		$datos = array('msg' => 'Fecha de Vuelo invalida','status' => false ,'code' => 400);
		return $datos;
	}
	$user=$_SESSION['bn_user_global'];
	$datos=$per->register_air($fecha_e,$id,$user);
	$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
	
}

/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_subscriber_masivo(){
	$per=new subscribers_model();
	$listas=$_POST['listas'];
	$archivo_n=$_FILES['archivo'];
	$status=1;
	$user=$_SESSION['bn_user_global'];

	$archivo = $_FILES['archivo']['name'];
	$tipo = $_FILES['archivo']['type'];
	$destino=$_SESSION['ruta_img'].'files_subscribers/'.$archivo;

	$ext = pathinfo($_FILES['archivo']['name'], PATHINFO_EXTENSION);
	if ($ext=="xlsx" || $ext=="xls" || $ext=="xml") {
		if (copy($_FILES['archivo']['tmp_name'],$destino)){
		}else {
			$datos = array('msg' => 'Error Al Cargar el Archivo','status' => false ,'code' => 400);
			return $datos;
		}
	}else{
		$datos = array('msg' => 'Error Al Cargar el Archivo Extension Invalida','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$this->validate_subscriber_masivo($destino,$listas);
	if (!$valid['status']) {
		return $valid;
	}
    $completos=$valid['completos'];
	$datos=$per->register_subscriber_masivo($listas,$completos,$user);
	$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
	
}


/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_subscriber_masivo($destino,$listas){

	require_once('includes/PHPExcel/Classes/PHPExcel.php');
	require_once('includes/PHPExcel/Classes/PHPExcel/Reader/Excel2007.php');

	$inputFileType = PHPExcel_IOFactory::identify($destino);
	$inputFileType = PHPExcel_IOFactory::identify($destino);
	$objReader = PHPExcel_IOFactory::createReader($inputFileType);
	$objPHPExcel = $objReader->load($destino);
	$sheet = $objPHPExcel->getSheet(0); 
	$highestRow = $sheet->getHighestRow(); 
	$highestColumn = $sheet->getHighestColumn();
	$per=new subscribers_model();

	$num=0;
	$completos[] =new stdClass;
	for ($row = 2; $row <= $highestRow; $row++){
		$date=date('Y-m-d H:i:s');
		$reference=$sheet->getCell("A".$row)->getValue();
		$emision=$sheet->getCell("B".$row)->getValue();
		$inicio=$sheet->getCell("C".$row)->getValue();
		$fin=$sheet->getCell("D".$row)->getValue();
		$paisorigen=$sheet->getCell("E".$row)->getValue();
		$name=$sheet->getCell("F".$row)->getValue();
		$apellido=$sheet->getCell("G".$row)->getValue();
		$fecha_nac=$sheet->getCell("H".$row)->getValue();
		$identifiacion=$sheet->getCell("I".$row)->getValue();
		$email=$sheet->getCell("J".$row)->getValue();
		$telefono=$sheet->getCell("K".$row)->getValue();
		$sexo=$sheet->getCell("L".$row)->getValue();
		$email_e=$sheet->getCell("M".$row)->getValue();
		$email=($email == "#") ? $email_e : $email;
		$perfil=$sheet->getCell("N".$row)->getValue();
		$agente=$sheet->getCell("O".$row)->getValue();
		if (empty($reference)) {
			break;
		}
		if (strlen($name) > 100 || empty($name)) {
			$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 100 caracteres. Fila numero '.$row,'status' => false ,'code' => 400);
			return $datos;
		}
		if (strlen($apellido) > 100 || empty($apellido)) {
			$datos = array('msg' => 'Apellido no debe estar vacío ni superar los 100 caracteres. Fila numero '.$row,'status' => false ,'code' => 400);
			return $datos;
		}
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$datos = array('msg' => 'Email invalido. Fila numero '.$row,'status' => false ,'code' => 400);
			return $datos;
		}
		if ($email_e !== "#") {
			if (!filter_var($email_e, FILTER_VALIDATE_EMAIL)) {
				$datos = array('msg' => 'Email de emergencia invalido. Fila numero '.$row,'status' => false ,'code' => 400);
				return $datos;
			}
		}
		if (strlen($agente) > 20 ) {
			$datos = array('msg' => 'Agente no debe superar los 20 caracteres. Fila numero '.$row,'status' => false ,'code' => 400);
			return $datos;
		}
		if (strlen($telefono) > 50) {
			$datos = array('msg' => 'Telefono no debe estar vacío ni superar los 50 caracteres. Fila numero '.$row,'status' => false ,'code' => 400);
			return $datos;
		}
		if ($sexo != "F" & $sexo != "M" & $sexo != "#") {
			$datos = array('msg' => 'Sexo invalido. Fila numero '.$row,'status' => false ,'code' => 400);
			return $datos;
		}

		if ($reference !== "#") {
			$valid=$per->chek_localizador($reference);
			if (!$valid) {
				$datos = array('msg' => 'Numero de localizador ya existe. Fila numero '.$row,'status' => false ,'code' => 400);
				return $datos;
			} 
		}

		if ($emision !== "#") {
			$emision = date($format = "Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($emision));
			$emision=date("Y-m-d",strtotime($emision."+ 1 days")); 
			$valid=$per->validateDate($emision);
			if (!$valid) {
				$datos = array('msg' => 'Fecha de emision llegada. Fila numero '.$row,'status' => false ,'code' => 400);
				return $datos;
			}   
		}

		if ($inicio !== "#") {
			$inicio = date($format = "Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($inicio));
			$inicio=date("Y-m-d",strtotime($inicio."+ 1 days")); 
			$valid=$per->validateDate($inicio);
			if (!$valid) {
				$datos = array('msg' => 'Fecha de salida invalida. Fila numero '.$row,'status' => false ,'code' => 400);
				return $datos;
			}   
		}

		if ($fin !== "#") {
			$fin = date($format = "Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($fin));
			$fin=date("Y-m-d",strtotime($fin."+ 1 days")); 
			$valid=$per->validateDate($fin);
			if (!$valid) {
				$datos = array('msg' => 'Fecha de llegada invalida. Fila numero '.$row,'status' => false ,'code' => 400);
				return $datos;
			}   
		}

		if ($fecha_nac !== "#") {
			$fecha_nac = date($format = "Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($fecha_nac));
			$fecha_nac=date("Y-m-d",strtotime($fecha_nac."+ 1 days")); 
			$valid=$per->validateDate($fecha_nac);
			if (!$valid) {
				$datos = array('msg' => 'Fecha de nacimiento invalida. Fila numero '.$row,'status' => false ,'code' => 400);
				return $datos;
			}   
		}

		if ($identifiacion !== "#") {
			$valid=$per->chekc_identifiacion($identifiacion);
			if (!$valid) {
				$datos = array('msg' => 'Identifiacion ya existe. Fila numero '.$row,'status' => false ,'code' => 400);
				return $datos;
			} 
		}
		$completos[$num]->reference = $reference;
		$completos[$num]->emision = $emision;
		$completos[$num]->inicio = $inicio;
		$completos[$num]->fin = $fin;
		$completos[$num]->paisorigen = $paisorigen;
		$completos[$num]->name = $name;
		$completos[$num]->apellido = $apellido;
		$completos[$num]->fecha_nac = $fecha_nac;
		$completos[$num]->identifiacion = $identifiacion;
		$completos[$num]->email = $email;
		$completos[$num]->telefono = $telefono;
		$completos[$num]->sexo = $sexo;
		$completos[$num]->email_e = $email_e;
		$completos[$num]->perfil = $perfil;
		$completos[$num]->agente = $agente;
		$num++;
	}
	if (!is_array($listas) || count($listas) < 1) {
		$datos = array('msg' => 'Lista no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($listas as $value) {
		$valid=$per->query_lists($value);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Lista no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}

	$datos = array('msg' => 'GOOD','status' =>true,'completos' => $completos);
	return $datos;
}


}
?>