<?php
//Llamada al modelo
require 'model/services_model.php';

class services_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_service($name,$descripcion,$imagen,$status,$id){
	$per=new services_model();
	if (strlen($name) > 50 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($imagen)) {
		$ext = pathinfo($imagen['name'], PATHINFO_EXTENSION);
		if ($ext!=="png" && $ext!=="jpg" && $ext!=="jpeg") {
			$datos = array('msg' => 'Error formato de imagen.','status' => false ,'code' => 400);
			return $datos;
		}
		$tamaño = getimagesize($imagen['tmp_name']);
		if ($tamaño[0]> 5000 || $tamaño[1] > 5000 || $imagen['size'] > 500000) {		
			$datos = array('msg' =>'Error, la imagen debe tener un ancho inferior a 5000px y una altura de 5000px.','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_service($id);
		if (!$valid) {
			$datos = array('msg' => 'Servicio no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id);
	if (!$valid) {
		$datos = array('msg' => '¡Error! Nombre existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de Servicios.
*
*Funcion para consultar Servicios registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_services(){
	$per=new services_model();
	$datos=$per->query_services(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_service(){
	$per=new services_model();
	$name=$_POST['name'];
	$descripcion=$_POST['descripcion'];
	$imagen=$_FILES['imagen'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_service($name,$descripcion,$imagen,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_service($name,$descripcion,$imagen,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de Servicios.
*
*Funcion para consultar Servicios registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de Servicios
*/
public function view_service(){
	$var1=$_POST['id'];
	$per=new services_model();
	$datos=$per->query_services($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Servicio no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar Servicios.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_service(){
	$per=new services_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$descripcion=$_POST['descripcion'];
	$imagen=$_FILES['imagen'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_service($name,$descripcion,$imagen,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_service($name,$descripcion,$imagen,$status,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_service(){
	$per=new services_model();
	$data1=$_POST['id'];
	$valid=$per->check_service($data1);
	if (!$valid) {
		$datos = array('msg' => 'Servicio no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_service($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

}
?>