<?php
//Llamada al modelo
require 'model/schedules_model.php';

class schedules_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_schedule($name,$fecha,$color,$id,$user){
	$per=new schedules_model();
	if (strlen($name) > 150 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni exceder los 150 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($color) > 100 || empty($color)) {
		$datos = array('msg' => 'El color no debe estar vacío ni exceder los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($id) && !empty($fecha)) {
	$valid=$per->validateDate($fecha);
	if (!$valid) {
		$datos = array('msg' => 'Fecha invalida','status' => false ,'code' => 400);
		return $datos;
	}
	}
	if (!is_null($id)) {
		$valid=$per->check_schedule($id,$user);
		if (!$valid) {
			$datos = array('msg' => 'Agenda no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_schedules(){
	$per=new schedules_model();
	$user=$_SESSION['bn_user_global_advisers'];
	$datos=$per->query_schedules(NULL,$user);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_schedule(){
	$per=new schedules_model();
	$name=$_POST['name'];
	$fecha=$_POST['fecha'];
	$color=$_POST['color'];
	$user=$_SESSION['bn_user_global_advisers'];
	$valid=$this->validate_schedule($name,$fecha,$color,NULL,$user);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_schedule($name,$fecha,$color,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Editar empleados.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_schedule(){
	$per=new schedules_model();
	$id=$_POST['id'];
	$name=$_POST['name'];
	$fecha=$_POST['fecha'];
	$color=$_POST['color'];
	$user=$_SESSION['bn_user_global_advisers'];
	$valid=$this->validate_schedule($name,$fecha,$color,$id,$user);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_schedule($name,$fecha,$color,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_schedule(){
	$per=new schedules_model();
	$data1=$_POST['id'];
	$user=$_SESSION['bn_user_global_advisers'];

	$valid=$per->check_schedule($data1,$user);
	if (!$valid) {
		$datos = array('msg' => 'Agenda no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_schedule($data1,$user);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

}
?>