<?php
//Llamada al modelo
require 'core/model/reports_insurance_model.php';

class reports_bee
{

	private $modulo;
	public function __construct(){
		$this->modulo="Report";

	}

/**
* Consulta de managers.
*
*Funcion para consultar managers registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function check_buy_adviser($id){
	$user=$_SESSION['bn_user_global_advisers'];
	$per=new reports_insurance_model();
	$datos=$per->check_buy($id);
	if ($datos['status']) {
    $datos=($user !== $datos['id']) ? false : true;
	}else{
	$datos=$datos['status'];
	}
	return $datos;
}
/**
* Eliminar manager.
*
*Funcion para Eliminar manager, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function reports_insurance($id){
	$per=new reports_insurance_model();
	$datos2=$per->query_buy($id);
	$datos3=$per->query_beneficiarios($id);

	$count=count($datos2);
	$data="";
	foreach ($datos2 as $value) {
		$formulario=$value["id_insurance"];
		$token=$value["token_buy"];
		$n_poliza=str_pad($value["id_buy"],6,"0",STR_PAD_LEFT);
		$asegurado=$value["name_user"].' '.$value["last_name_user"].' ,  No identificación '.$value["user_id"].', residente de '.$value["pais"];
		$sexo=($value["sex_user"]=="F")?'Femenino':'Masculino';
		$fuma=($value["smokes_user"]=="1")?'Si':'No';

		$email_asegurado=$value["email_user"];
		$nombres_asegurado=$value["name_user"].' '.$value["last_name_user"];
		$precio_plan=number_format($value['precio'],2,',','.');
		$pago=number_format($value["pago"],2,',','.');
		$descripcion_precio=$value["descripcion_precio"];
		$titulo='Certificadopoliza_'.$n_poliza.'.pdf';
		$titlepdf=$value["title_pdf"];
        $perfil=$value["perfil"];

		switch ($perfil) {
			case 'Agencia':
			$name_agente=$value["nombre_agencia"];
			$perfil_name="Agencia";
			break;
			case 'Asesor':
			$name_agente=$value["nombre_asesor"];
			$perfil_name="Asesor";
			break;
			case 'Agencia IBO':
			$name_agente=$value["agencia_ibo"];
			$perfil_name="Agencia";
			break;
			default:
			$name_agente="Web";
			$perfil_name="Web";
			break;
		}

		$data.='<tr><td align="center"><b>PÓLIZA No</b></td><td align="center">'.$n_poliza.'</td></tr>';
		if (!empty($descripcion_precio)) {
			$data.='<tr><td align="center"><b>COBERTURA</b></td><td align="center">US$ '.$precio_plan.'</td></tr>';
			$data.='<tr><td align="center"><b></b></td><td align="center">'.$descripcion_precio.'</td></tr>';

		}else{
			$data.='<tr><td align="center"><b>COBERTURA</b></td><td align="center">US$ '.$precio_plan.'</td></tr>';
		}
		$data.='<tr><td align="center"><b>DESDE</b></td><td align="center">'.$value["start_date"].' (inicio de cobertura)</td></tr>';
		$data.='<tr><td align="center"><b>HASTA</b></td><td align="center">'.$value["end_date"].' (fin de cobertura)</td></tr>';
		$data.='<tr><td align="center"><b>PAGO</b></td><td align="center">US$ '.$pago.' (pago único)</td></tr>';
		$data.='<tr><td align="center"><b>ASEGURADO</b></td><td align="center">'.$asegurado.'</td></tr>';
		$data.='<tr><td align="center"><b>NACIMIENTO</b></td><td align="center">'.$value["date_birth"].' (Inicia la cobertura con '.$value["age_user"].' años)</td></tr>';
		if ($formulario == "7"){
		$data.='<tr><td align="center"><b>PERFIL</b></td><td align="center">Sexo: '.$sexo.'</td></tr>';
	    }else{
		$data.='<tr><td align="center"><b>PERFIL</b></td><td align="center">Sexo: '.$sexo.' Fuma: '.$fuma.'</td></tr>';	
	    }
		$data.='<tr><td align="center"><b>CONTACTO</b></td><td align="center">Email: '.$value["email_user"].' Teléfono: '.$value["phone_user"].'</td></tr>';

        if ($perfil !== "Web") {
		$data.='<tr><td align="center"><b>'.$perfil_name.'</b></td><td align="center">'.$name_agente.'</td></tr>';
        }

	}
	$datos4=$per->query_declaracion($formulario);
	$declaracion="";
	foreach ($datos4 as $value) {
		$id_d=$value['id_declaration_health'];
		$declaracionoption=$value['option_detail'];
		$datos5=$per->query_declaracion_resp($id_d,$id);
		$opcion='No';
		$detalles=''; 
		if ($datos5['status']) {
			$opcion='Sí';
			if ($declaracionoption=="1") {
				$detalles='<p style="text-align: justify;">Detalles: '.$datos5["descripcion"].'</p>';
			}
		}
		$declaracion.='<p style="text-align: justify;">'.$value["name_declaration_health"].'- Declaró que '.$opcion.'</p>'.$detalles;

	}	
	$beneficiarios="";
	$parentesco_array=['','Abuelo(a)','Padre/Madre','Hijo(a)','Nieto(a)','Cónyugue','Hermano(a)','Socio(a)'];
	if (count($datos3) > 0) {
		foreach ($datos3 as $value) {
			$parentesco=$parentesco_array[$value["id_relationship"]];
			$beneficiarios.='<tr><td style="text-align: center;">'.$value["name_beneficiary"].'</td><td style="text-align: center;">'.$value["identification"].'</td><td style="text-align: center;">'.$parentesco.'</td><td style="text-align: center;">'.$value["percentage_beneficiary"].'</td></tr>';
		}
	}else{
		$beneficiarios.='<tr><td colspan="4" style="text-align: center;">Sin beneficiarios nombrados-herederos legales</td></tr>';
	}
	$template ='core/reports_view/reports_tasks.php';

	$template =($formulario == "7") ? 'core/reports_view/reports_especial.php' : 'core/reports_view/reports_tasks.php';


	$html = file_get_contents($template);
	$html = str_replace('{{titlepdf}}', $titlepdf, $html);
	$html = str_replace('{{data}}', $data, $html);
	$html = str_replace('{{beneficiarios}}', $beneficiarios, $html);
	$html = str_replace('{{declaracion}}', $declaracion, $html);

	return ['pdf' => $html,'token' => $token,'titlepdf' => $titlepdf,'titulo' =>$titulo,'email' =>$email_asegurado,'name' =>$nombres_asegurado,'n_poliza' =>$n_poliza];

}

/**
* Eliminar manager.
*
*Funcion para Eliminar manager, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function reports_contracts($perfil,$user){
	$per=new reports_insurance_model();
	$datos=$per->query_contract(2);
	$datos2=$per->query_files($perfil,$user);
	$nombre=(is_null($datos2[0]['nombres'])) ? "NOMBRES" : $datos2[0]['nombres'];
	$firma=(is_null($datos2[0]['archivo'])) ? "firma-digital.png" : $datos2[0]['archivo'];
	
	$firma='<img src="'.$url_admin.'dist/files_kyc/'.$firma.'" alt="Firma Digital" style="height:100px;width:150px;">';
	$body=$datos;
	$body = str_replace('{{Firma_digital}}', $firma, $body);
	$body = str_replace('{{Nombres}}', $nombre, $body);

	$titulo='Contrato_'.$nombre.'.pdf';
	$titlepdf="CONTRATO DE ALIANZA COMERCIAL";
	$template ='core/reports_view/reports_contracts.php';
	$html = file_get_contents($template);
	$html = str_replace('{{titlepdf}}', $titlepdf, $html);
	$html = str_replace('{{body}}', $body, $html);

	return ['pdf' => $html,'titlepdf' => $titlepdf,'titulo' =>$titulo];

}


}
?>