<?php
//Llamada al modelo
require_once('core/mpdf/mpdf.php');

class reports_certificates
{
	private $modulo;
	public function __construct(){
		$this->modulo="Report";

	}

/**
* Consulta de managers.
*
*Funcion para consultar managers registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function pdf_subscriber($id,$name,$apellido,$email,$fecha_n,$salida,$fin,$poliza,$localizador){
	$html=$this->report_certificate($id,$name,$apellido,$email,$fecha_n,$salida,$fin,$poliza,$localizador);
	$this->create_pdf($html);
	return $html['titulo']; 
}
/**
* Eliminar manager.
*
*Funcion para Eliminar manager, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function create_pdf($html){
	$date = date('d-m-Y') ;
	$header = '<div style="background-color: #fff; color:#000; width:100%;"><center><h1 style="text-align: center;">¡Gracias por preferirnos!</h1><p style="text-align: center;">Esto es un beneficio exclusivo que Vision Travel obsequia a sus clientes por la compra de su boleto</p></center></div>' ;
	$footer = '<div style="text-align: center;">WhatsApp: +17867825313 | email: info@bee-insurance.com | web: www.bee-insurance.com</div>';

	$pdf=new Mpdf('c','A4',NULL,'helvetica');
	$pdf->SetMargins(0, 0, 35);
	$pdf->setHeader($header);
	$pdf->setFooter($footer);
	$pdf->SetWatermarkImage('dist/img/logo2.png');
	$pdf->showWatermarkImage = true;
    $pdf->allow_charset_conversion=true;
    $pdf->charset_in='UTF-8';
    $htmltext = mb_convert_encoding($html['pdf'], 'UTF-8', 'UTF-8');
	$pdf->WriteHTML($htmltext);
    $pdf->Output('dist/files_certificate/'.$html['titulo'], 'F'); 
}
/**
* Eliminar manager.
*
*Funcion para Eliminar manager, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function report_certificate($id,$name,$apellido,$email,$fecha_n,$salida,$fin,$poliza,$localizador){
 
    $date=date('Y-m-d-H-i-s');
	$titulo='certificado'.$id.$name.'.pdf';
	$titlepdf="Certificado de poliza de vida";
    $periodo=date("Y-m-d",strtotime($salida."+ 15 days")); 
    $data='<p style="text-align: center;"><b>Nro.Poliza: </b>'.$poliza.'</p> <p style="text-align: center;"><b>Localizador: </b>'.$localizador.'</p>';
	$data.='<p style="text-align: center;"><b>Nombre y Apellido del titular: </b>'.$name.' '.$apellido.'</p>';
	$data.='<p style="text-align: center;"><b>Fecha de nacimiento: </b>'.$fecha_n.'</p>';
	$data.='<p style="text-align: center;"><b>Email: </b>'.$email.'</p>';
	$data.='<p style="text-align: center;"><b>Fecha de inicio del viaje y día 1 de póliza: </b>'.$salida.'</p>';
	$data.='<p style="text-align: center;"><b>Fecha de vencimiento de póliza (Día 15): </b>'.$periodo.'</p>';
	$data.='<p style="text-align: center;"><b>Fecha de regreso de viaje: </b>'.$fin.'</p>';
	$data.='<p style="text-align: center;"><b>Suma asegurada: </b> USD 10.000</p>';
	$enlace='<p>Debido a la naturaleza de esta póliza se hace necesario que el titular indique quién(es) será(n) su(s) beneficiario(s) en caso de fallecimiento. Para ello deberá hacer clic en este <a href="https://bee-insurance.com/beneficiarios.php?localizador='.$localizador.'">enlace</a> para llenar los datos. De no declarar beneficiario(s) durante su vigencia y en el caso inesperado de un siniestro la póliza de vida será pagada a su(s) heredero(s) legal(es).</p>';

	
	$template ='core/reports_view/reports_certificate2.php';
	$html = file_get_contents($template);
	$html = str_replace('{{titlepdf}}', $titlepdf, $html);
	$html = str_replace('{{datos}}', $data, $html);
	$html = str_replace('{{enlace}}', $enlace, $html);

	return ['pdf' => $html,'titlepdf' => $titlepdf,'titulo' =>$titulo];

}

}
?>