<?php
//Llamada al modelo
require 'model/incidents_model.php';

class incidents_controller
{


/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_incident($id,$status){
	$per=new incidents_model();
	if ($status != "1" && $status != "10" && $status != "11") {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per->check_id($id);
	if (!$valid) {
		$datos = array('msg' => '¡Error! Incidencia no existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_incidents(){
	$per=new incidents_model();
	$datos=$per->query_incidents(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de empleados
*/
public function view_incident(){
	$var1=$_POST['id'];
	$per=new incidents_model();
	$datos=$per->query_incidents($var1);
	if (count($datos) > 0) {
	    $datos2=$per->query_files($var1);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'files' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Incidencia no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Registrar incident.
*
*Funcion para Registrar incident, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_incident(){
	$per=new incidents_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_incident($id,$status);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_incident($id,$status,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}

}
?>