<?php
//Llamada al modelo
require 'model/declaration_health_model.php';

class declaration_health_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_declaration_health($name,$opcion_detalle,$status,$id){
	$per=new declaration_health_model();
	if (empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($opcion_detalle) && $opcion_detalle > 2) {
		$datos = array('msg' => 'Detalle invalid','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_declaration_health($id);
		if (!$valid) {
			$datos = array('msg' => 'Declaracion de salud no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id);
	if (!$valid) {
		$datos = array('msg' => 'Error! Nombre existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_declaration_health(){
	$per=new declaration_health_model();
	$datos=$per->query_declaration_health(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_declaration_health(){
	$per=new declaration_health_model();
	$name=$_POST['name'];
	$opcion_detalle=$_POST['opcion_detalle'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_declaration_health($name,$opcion_detalle,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_declaration_health($name,$opcion_detalle,$status,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de empleados
*/
public function view_declaration_health(){
	$var1=$_POST['id'];
	$per=new declaration_health_model();
	$datos=$per->query_declaration_health($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Declaracion de salud no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar empleados.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_declaration_health(){
	$per=new declaration_health_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$opcion_detalle=$_POST['opcion_detalle'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_declaration_health($name,$opcion_detalle,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_declaration_health($name,$opcion_detalle,$status,$user,$id);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_declaration_health(){
	$per=new declaration_health_model();
	$data1=$_POST['id'];
	$valid=$per->check_declaration_health($data1);
	if (!$valid) {
		$datos = array('msg' => 'Declaracion de salud no existe','status' => false,'code' => 400);
		return $datos;
	}
	$valid=$per->check_form($data1);
	if (!$valid) {
		$datos = array('msg' => 'Declaracion de salud tiene formulario asociado, solo se puede desactivar','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_declaration_health($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_declaration_age_groups($grupo,$puntos,$id,$id1){
	$per=new declaration_health_model();

	$valid=$per->check_group($grupo);
	if (!$valid) {
		$datos = array('msg' => 'Grupo etario no existe','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_numeric($puntos) || $puntos > 100) {
		$datos = array('msg' => 'Puntos invalido','status' => false ,'code' => 400);
		return $datos;
	}

	$valid=$per->check_declaration_health($id);
	if (!$valid) {
		$datos = array('msg' => 'Declaracion de riesgo no existe','status' => false ,'code' => 400);
		return $datos;
	}
	
	if (!is_null($id1)) {
		$valid=$per->check_declaration_age_groups($id,$id1);
		if (!$valid) {
			$datos = array('msg' => 'Grupo etario de declaracion no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}

	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Vista de ajustes.
*
*Funcion para consultar ajustes registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de ajustes
*/
public function query_settings(){
	$var1=$_POST['id'];
	$per=new declaration_health_model();
	$datos=$per->query_settings($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Declaracion no posee grupos etarios','status' => false,'code' => 400);
	}
	return $datos1;
}

/**
* Registrar ajustes.
*
*Funcion para Registrar ajustes, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_declaration_age_groups(){
	$per=new declaration_health_model();
	$grupo=$_POST['grupo'];
	$puntos=$_POST['puntos'];
	$id=$_POST['id'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_declaration_age_groups($grupo,$puntos,$id,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_declaration_age_groups($grupo,$puntos,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}

/**
* Editar ajustes.
*
*Funcion para Registrar ajustes, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_declaration_age_groups(){
	$per=new declaration_health_model();
	$grupo=$_POST['grupo'];
	$puntos=$_POST['puntos'];
	$id=$_POST['id'];
	$declaracion=$_POST['declaracion'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_declaration_age_groups($grupo,$puntos,$declaracion,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_declaration_age_groups($grupo,$puntos,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}

/**
* Elimimar ajuste.
*
*Funcion para eliminar ajuste, chequea si el ajuste existe si arroja true elimina el ajuste*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_declaration_age_groups(){
	$per=new declaration_health_model();
	$data1=$_POST['id'];
	$data2=$_POST['data2'];

	$valid=$per->check_declaration_age_groups($data2,$data1);
	if (!$valid) {
		$datos = array('msg' => 'Grupo etario no existe','status' => false,'code' => 400);
		return $datos;
	}
	$opcion=1;
	$user=$_SESSION['bn_user_global'];
	$datos=$per->delete_declaration_age_groups($data1,1,$user);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

}
?>