<?php
//Llamada al modelo
require 'model/contacts_model.php';

class contacts_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_contact($facebook,$instagram,$twitter,$whatsapp,$tlf,$email,$direccion,$mapa){
	$per=new contacts_model();
	if (!filter_var($facebook, FILTER_VALIDATE_URL)) {
		$datos = array('msg' => 'Url Facebook invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($instagram, FILTER_VALIDATE_URL)) {
		$datos = array('msg' => 'Url Instagram invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($twitter, FILTER_VALIDATE_URL)) {
		$datos = array('msg' => 'Url Twitter invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($whatsapp, FILTER_VALIDATE_URL)) {
		$datos = array('msg' => 'Url Whatsapp invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		$datos = array('msg' => 'Email invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($mapa, FILTER_VALIDATE_URL)) {
		$datos = array('msg' => 'Url Google maps invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($tlf) > 25 || empty($tlf)) {
		$datos = array('msg' => 'Telefono no debe estar vacío ni exceder los 25 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($direccion) > 200 || empty($direccion)) {
		$datos = array('msg' => 'Direccion no debe estar vacío ni exceder los 200 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_contacts(){
	$per=new contacts_model();
	$datos=$per->query_contacts(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Editar empleados.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_contact(){
	$per=new contacts_model();
	$facebook=$_POST['facebook'];
	$instagram=$_POST['instagram'];
	$twitter=$_POST['twitter'];
	$whatsapp=$_POST['whatsapp'];
	$tlf=$_POST['tlf'];
	$email=$_POST['email'];
	$direccion=$_POST['direccion'];
	$mapa=$_POST['mapa'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_contact($facebook,$instagram,$twitter,$whatsapp,$tlf,$email,$direccion,$mapa);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_contact($facebook,$instagram,$twitter,$whatsapp,$tlf,$email,$direccion,$mapa,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

}
?>