<?php
//Llamada al modelo
require 'model/campaigns_push_model.php';
require 'model/subscribers_model.php';

class campaigns_push_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_campaign($name,$asunto_principal,$fecha_e,$descripcion_principal,$listas,$status,$id){
	$per=new campaigns_push_model();
	$per1=new subscribers_model();

	if (strlen($name) > 100 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($asunto_principal)) {
		if (strlen($asunto_principal) > 100 || empty($asunto_principal)) {
			$datos = array('msg' => 'Asunto no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
			return $datos;
		}}
		$fecha = explode("-", $fecha_e);
		$fechai = date("Y-m-d", strtotime($fecha[0]));
		$fechaf = date("Y-m-d", strtotime($fecha[1]));
		$date1=date_create($fechai);
		$date2 = date_create($fechaf);
		$diff = $date1->diff($date2);
		$diff= $diff->format('%R%a');
		$diff = substr($diff, 0,1);
		if($diff == "-"){
			$datos = array('msg' => 'Error Fecha invalida','status' => 'F');
			return $datos;
		}
		$valid=$per1->validateDate($fechai);
		if (!$valid) {
			$datos = array('msg' => 'Fecha de envio invalida','status' => false ,'code' => 400);
			return $datos;
		}
		$valid=$per1->validateDate($fechaf);
		if (!$valid) {
			$datos = array('msg' => 'Fecha de envio invalida','status' => false ,'code' => 400);
			return $datos;
		}
		if (!is_null($descripcion_principal)) {
			if (empty($descripcion_principal)) {
				$datos = array('msg' => 'Descripcion no debe estar vacío','status' => false ,'code' => 400);
				return $datos;
			}}
			if (!is_array($listas) || count($listas) < 1) {
				$datos = array('msg' => 'Lista no debe estar vacío ','status' => false ,'code' => 400);
				return $datos;
			}
			foreach ($listas as $value) {
				$valid=$per1->query_lists($value);
				if (count($valid) == 0) {
					$datos = array('msg' => 'Error! Lista no existe','status' => false ,'code' => 400);
					return $datos;
				}
			}
			$valid=$per->check_status($status);
			if (!$valid) {
				$datos = array('msg' => 'Status invalido','status' => false ,'code' => 400);
				return $datos;
			}

			if (!is_null($id)) {
				$valid=$per->check_campaign($id);
				if (!$valid) {
					$datos = array('msg' => 'Campaña no existe','status' => false ,'code' => 400);
					return $datos;
				}
			}

			$valid=$per->check_name($name,$id);
			if (!$valid) {
				$datos = array('msg' => '¡Error! Nombre existe','status' => false ,'code' => 400);
				return $datos;
			}
			$datos = array('msg' => 'GOOD','status' =>true);
			return $datos;
		}
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_campaign_item($asuntos,$periodos,$descripcions,$id){
	$per=new campaigns_push_model();
	if (count($asuntos) > 0 & count($periodos) > 0 & count($descripcions) > 0 ) {

		if (count($asuntos) != count($periodos) || count($descripcions) != count($asuntos) || count($descripcions) != count($periodos)) {
			$datos = array('msg' => 'Error numero de Item','status' => false ,'code' => 400);
			return $datos;
		}

		if (!is_array($asuntos) || count($asuntos) < 1) {
			$datos = array('msg' => 'Asunto de Item no debe estar vacío ','status' => false ,'code' => 400);
			return $datos;
		}
		if (!is_array($periodos) || count($periodos) < 1) {
			$datos = array('msg' => 'Periodo de Item no debe estar vacío ','status' => false ,'code' => 400);
			return $datos;
		}
		if (!is_array($descripcions) || count($descripcions) < 1) {
			$datos = array('msg' => 'Descripcion de Item no debe estar vacío ','status' => false ,'code' => 400);
			return $datos;
		}
		foreach ($asuntos as $asunto) {
			if (strlen($asunto) > 100 || empty($asunto)) {
				$datos = array('msg' => 'Asunto de Item no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
				return $datos;
			}
		}
		foreach ($periodos as $periodo) {
			if (!is_numeric($periodo) || empty($periodo) || strlen($periodo) > 2 || $periodo <= 0) {
				$datos = array('msg' => 'Periodo de Item debe ser numerico no debe estar vacío ni superar los 2 caracteres','status' => false ,'code' => 400);
				return $datos;
			}
		}
		foreach ($descripcions as $descripcion) {
			if (empty($descripcion)) {
				$datos = array('msg' => 'Descripcion no debe estar vacío','status' => false ,'code' => 400);
				return $datos;
			}
		}
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}
/**
* Consulta de campañas.
*
*Funcion para consultar campañas registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_campaigns_push(){
	$per=new campaigns_push_model();
	$decryp=new routehelper();
	$datos=$per->query_campaigns_push(NULL);
	foreach ($datos as &$value) {
		$datos2=$per->check_lists_campaigns_push($value['id'],2);
		$value['listas']=(count($datos2) == 0) ? [] : $datos2;
		$act=$value['id'];
		$act=$decryp->encryptroute($act);
		$value['id']=$act;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar camapña.
*
*Funcion para Registrar camapña, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_campaigns_push(){
	$per=new campaigns_push_model();
	$name=$_POST['name'];
	$asunto=$_POST['asunto_principal'];
	$fecha_e=$_POST['fecha_e'];
	$status=$_POST['status'];
	$descripcion=$_POST['descripcion_principal'];
	$listas=$_POST['listas'];
	$asuntos=(empty($_POST['asuntos']))?[]:$_POST['asuntos'];
	$periodos=(empty($_POST['periodos']))?[]:$_POST['periodos'];
	$descripcions=(empty($_POST['descripcions']))?[]:$_POST['descripcions'];
	$user=$_SESSION['bn_user_global'];
	//$opcion_push=$_POST['opcion_push'];
	$opcion_push=2;
	$valid=$this->validate_campaign($name,$asunto,$fecha_e,$descripcion,$listas,$status,NULL);
	$valid1=$this->validate_campaign_item($asuntos,$periodos,$descripcions,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		if (!$valid1['status']) {
			return $valid1;
		}
		$datos=$per->register_campaigns_push($name,$asunto,$fecha_e,$descripcion,$listas,$status,$user,$opcion_push);
		if ($datos['status'] & count($asuntos) > 0 & count($periodos) > 0 & count($descripcions) > 0 ) {
			$datos=$per->register_items_push($asuntos,$periodos,$descripcions,$datos['id'],$user);
		}
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos['status']) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de campaigns_push.
*
*Funcion para consultar campaigns_push registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns_push
*/
public function view_campaigns_push(){
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_push_model();
	$datos4=$per->dateils_campaign_item($var1);
	$datos=$per->dateils_campaigns_push($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists_campaigns_push($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'listas' => $datos2,'detalles' => $datos4,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Vista de campaigns_push.
*
*Funcion para consultar campaigns_push registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns_push
*/
public function dateils_campaigns_push(){
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_push_model();
	$datos=$per->dateils_campaign_item($var1);
	$datos4=$per->query_campaigns_push($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists_campaigns_push($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'datos4' => $datos4,'listas' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar campaigns_push.
*
*Funcion para Registrar camapña, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_item0_push(){
	$per=new campaigns_push_model();
	$id=$_POST['id'];
	$detalle=$_POST['detalle'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($id);
	$option=explode('/',trim($option));
	$id=$option[1];
	$asunto=$_POST['asunto'];
	$periodo=1;
	$descripcion=$_POST['descripcion'];
	$asuntos=[$asunto];
	$periodos=[$periodo];
	$descripcions=[$descripcion];
	$user=$_SESSION['bn_user_global'];
	$valid=$per->check_campaign_item($id,$detalle);
	if (!$valid) {
		$datos = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
		return $datos;
	}
	$valid1=$this->validate_campaign_item($asuntos,$periodos,$descripcions,NULL);
	if (!$valid1['status']) {
		return $valid;
	}else{
		$periodo="NULL";
		$datos=$per->edit_item_push($asunto,$periodo,$descripcion,$user,$id,$detalle);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}
/**
* Editar campaigns_push.
*
*Funcion para Registrar camapña, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_item_push(){
	$per=new campaigns_push_model();
	$id=$_POST['id'];
	$detalle=$_POST['detalle'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($id);
	$option=explode('/',trim($option));
	$id=$option[1];
	$asunto=$_POST['asunto'];
	$periodo=$_POST['periodo'];
	$descripcion=$_POST['descripcion'];
	$asuntos=[$asunto];
	$periodos=[$periodo];
	$descripcions=[$descripcion];
	$user=$_SESSION['bn_user_global'];
	$valid=$per->check_campaign_item($id,$detalle);
	if (!$valid) {
		$datos = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
		return $datos;
	}
	$valid1=$this->validate_campaign_item($asuntos,$periodos,$descripcions,NULL);
	if (!$valid1['status']) {
		return $valid1;
	}else{
		$datos=$per->edit_item_push($asunto,$periodo,$descripcion,$user,$id,$detalle);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}
/**
* Elimimar camapña.
*
*Funcion para eliminar camapña, chequea si el camapña existe si arroja true elimina el camapña*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_item(){
	$per=new campaigns_push_model();
	$id=$_POST['id'];
	$detalle=$_POST['detalle'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($id);
	$option=explode('/',trim($option));
	$id=$option[1];
	$valid=$per->check_campaign_item($id,$detalle);
	if (!$valid) {
		$datos = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_item($detalle);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => '!Email tiene envios asociados no se puede eliminar','status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
/**
* Editar campaigns_push.
*
*Funcion para Registrar camapña, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_campaigns_push(){
	$per=new campaigns_push_model();
	$id=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($id);
	$option=explode('/',trim($option));
	$id=$option[1];
	$name=$_POST['name'];
	$fecha_e=$_POST['fecha_e'];
	$status=$_POST['status'];
	$listas=$_POST['listas'];
	$asuntos=(empty($_POST['asuntos']))?[]:$_POST['asuntos'];
	$periodos=(empty($_POST['periodos']))?[]:$_POST['periodos'];
	$descripcions=(empty($_POST['descripcions']))?[]:$_POST['descripcions'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_campaign($name,NULL,$fecha_e,NULL,$listas,$status,$id);
	$user=$_SESSION['bn_user_global'];
	if (!$valid['status']) {
		return $valid;
	}else{
		$valid1=$this->validate_campaign_item($asuntos,$periodos,$descripcions,NULL);
		if (!$valid1['status']) {
			return $valid1;
		}
		$listas_s1=$per->check_lists_campaigns_push($id,1);
		$listas_s1=(count($listas_s1) == 0)? [] : $listas_s1;
		$agregar_s = array_diff($listas, $listas_s1);
		$eliminar_s = array_diff($listas_s1,$listas);

		$datos=$per->edit_campaigns_push($agregar_s,$eliminar_s,$name,$fecha_e,$status,$user,$id);

		if ($datos & count($asuntos) > 0 & count($periodos) > 0 & count($descripcions) > 0 ) {
			$datos=$per->register_items_push($asuntos,$periodos,$descripcions,$id,$user);
		}
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}
/**
* Duplicar de campaigns_push.
*
*Funcion para consultar campaigns_push registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns_push
*/
public function duplicate_campaigns_push(){
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_push_model();
	$user=$_SESSION['bn_user_global'];
	$datos=$per->query_campaigns_push($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists_campaigns_push($var1,2);
		$datos3=$per->dateils_campaign_item($var1);

		$datos=$per->duplicate_campaigns_push($datos,$datos2,$datos3,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}else{
		$datos1 = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Elimimar camapña.
*
*Funcion para eliminar camapña, chequea si el camapña existe si arroja true elimina el camapña*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_campaigns_push(){
	$per=new campaigns_push_model();
	$id=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($id);
	$option=explode('/',trim($option));
	$id=$option[1];
	$valid=$per->check_campaign($id);
	if (!$valid) {
		$datos = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_campaigns_push($id);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
/**
* Vista de campaigns_push.
*
*Funcion para consultar campaigns_push registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns_push
*/
public function lists_subscriber(){
	$var1=$_POST['id'];
	$lista=$_POST['lista'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_push_model();
	$datos=$per->lists_subscriber($var1,$lista);
	if (count($datos) > 0) {
		$x=1;
		foreach ($datos as &$value) {
			$value['num']=$x;
			//$value['num']='10.000$';
			$value['recibido']=1;
			$x++;
		}
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'No Posee Suscriptores Recibidos','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Vista de campaigns_push.
*
*Funcion para consultar campaigns_push registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns_push
*/
public function lists_subscriber_no(){
	$var1=$_POST['id'];
	$lista=$_POST['lista'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_push_model();
	$datos=$per->lists_subscriber_no($var1,$lista);
	if (count($datos) > 0) {
		$x=1;
		foreach ($datos as &$value) {
			$value['num']=$x;
			$value['recibido']=2;
			$x++;
		}
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Camapña no posee suscriptores no recibido','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Vista de campaigns_push.
*
*Funcion para consultar campaigns_push registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns_push
*/
public function lists_subscriber_visiontotal(){
	$lista=$_POST['lista'];
	$var1=8;
	$per=new campaigns_push_model();

	$fecha=$_POST['fecha'];
	if (!empty($fecha)) {
	$fecha = explode("-", $fecha);
	$fechai = date("Y-m-d", strtotime($fecha[0]));
	$fechaf = date("Y-m-d", strtotime($fecha[1]));
	$date1=date_create($fechai);
	$date2 = date_create($fechaf);
	$diff = $date1->diff($date2);
	$diff= $diff->format('%R%a');
	$diff = substr($diff, 0,1);
	if($diff == "-"){
		$datos = array('msg' => 'Error Date','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->lists_subscriber_visiontotal($var1,$fechai,$fechaf);
    }else{
	$datos=$per->lists_subscriber_visiontotal($var1,NULL,NULL);
    $fechai = date("Y-m-01");
    $fechaf = date("Y-m-t");  
    }
	//$datos=$per->lists_subscriber_vision($var1);
	if (count($datos) > 0) {
		$x=1;
		foreach ($datos as &$value) {
			//$value['num']=$x;
			$value['num']='USD10.000';
			$value['recibido']=1;
			$x++;
		}
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'fechai'=>$fechai,'fechaf'=>$fechaf,'code' => 200);
	}else{
		$datos1 = array('msg' => 'No Posee Suscriptores Recibidos','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Vista de campaigns_push.
*
*Funcion para consultar campaigns_push registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns_push
*/
public function lists_subscriber_vision(){
	$lista=$_POST['lista'];
	$var1=8;
	$per=new campaigns_push_model();
	$datos=$per->lists_subscriber_vision($var1,$lista);
	if (count($datos) > 0) {
		$x=1;
		foreach ($datos as &$value) {
			//$value['num']=$x;
			$value['num']='USD10.000';
			$value['recibido']=1;
			$x++;
		}
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'No Posee Suscriptores Recibidos','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Vista de campaigns_push.
*
*Funcion para consultar campaigns_push registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns_push
*/
public function lists_subscriber_no_vision(){
	$lista=$_POST['lista'];
	$var1=8;
	$per=new campaigns_push_model();
	$datos=$per->lists_subscriber_no_vision($var1,$lista);
	if (count($datos) > 0) {
		$x=1;
		foreach ($datos as &$value) {
			$value['num']='USD10.000';
			$value['recibido']=2;
			$x++;
		}
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Camapña no posee suscriptores no recibido','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_asegurado($name,$apellido,$email,$tlf,$fecha_nac,$fechai,$fechaf,$identificacion,$id){
	$per=new campaigns_push_model();
	if (strlen($name) > 50 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($apellido) > 50 || empty($apellido)) {
		$datos = array('msg' => 'Apellido no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($identificacion) > 50 || empty($identificacion)) {
		$datos = array('msg' => 'Identificacion no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		$datos = array('msg' => 'Email invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($tlf) > 50 || empty($tlf)) {
		$datos = array('msg' => 'Telefono no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$this->validateDate($fecha_nac);
	if (!$valid) {
		$datos = array('msg' => 'Fecha de nacimiento invalida','status' => false ,'code' => 400);
		return $datos;
	}

	$valid=$this->validateDate($fechai);
	if (!$valid) {
		$datos = array('msg' => 'Fecha de Vuelo invalida','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$this->validateDate($fechaf);
	if (!$valid) {
		$datos = array('msg' => 'Fecha de Vuelo invalida','status' => false ,'code' => 400);
		return $datos;
	}

	$date1=date_create($fechai);
	$date2 = date_create($fechaf);
	$diff = $date1->diff($date2);
	$diff= $diff->format('%R%a');
	$diff = substr($diff, 0,1);
	if($diff == "-"){
		$datos = array('msg' => 'Fecha de Vuelo invalida','status' => 'F');
		return $datos;
	}

	$valid=$per->query_subscribers($id);
	if (count($valid) == 0) {
		$datos = array('msg' => 'Asegurado no existe','status' => false ,'code' => 400);
		return $datos;
	}
	
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}
/**
* Validar de fecha.
*
*
* @return Boolean
*/
function validateDate($date, $format = 'Y-m-d')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}
/**
* Vista de subscribers.
*
*Funcion para consultar subscribers registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de subscribers
*/
public function view_asegurado(){
	$var1=$_POST['id'];
	$per=new campaigns_push_model();
	$datos=$per->query_subscribers($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'subscriber no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar subscribers.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_asegurado(){
	$per=new campaigns_push_model();
	$id=$_POST['id'];
	$name=$_POST['name'];
	$apellido=$_POST['apellido'];
	$email=$_POST['email'];
	$tlf=$_POST['tlf'];
	$fecha_nac=$_POST['fecha_nac'];
	$identificacion=$_POST['identificacion'];
	$fecha_e=$_POST['fecha_vuelo'];
	$fecha = explode("-", $fecha_e);
	$fechai = date("Y-m-d", strtotime($fecha[0]));
	$fechaf = date("Y-m-d", strtotime($fecha[1]));
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_asegurado($name,$apellido,$email,$tlf,$fecha_nac,$fechai,$fechaf,$identificacion,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_asegurado($name,$apellido,$email,$tlf,$fecha_nac,$fechai,$fechaf,$identificacion,$id,$user);
		if ($datos) {
        require_once('controller/reports_certificate_controller.php');
        $class=new reports_certificates();
		$query=$per->query_subscribers($id);
        
        $archivo=$class->pdf_subscriber($query[0]['suscrictor'],$name,$apellido,$email,$fecha_nac,$fechai,$fechaf,$id,$query[0]['localizador']);

		$datos=$per->edit_asegurado_pdf($archivo,$query[0]['suscrictor'],$user);

		}
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_products(){
	$per=new campaigns_push_model();
	$datos=$per->query_products(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}

}
?>