<?php
//Llamada al modelo
require 'model/campaigns_model.php';
require 'model/subscribers_model.php';

class campaigns_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_campaign($name,$asunto,$fecha_e,$descripcion,$listas,$status,$id){
	$per=new campaigns_model();
	$per1=new subscribers_model();

	if (strlen($name) > 100 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($asunto) > 100 || empty($asunto)) {
		$datos = array('msg' => 'Asunto no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per1->validateDate($fecha_e);
	if (!$valid) {
		$datos = array('msg' => 'Fecha de envio invalida','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per->validateDate_now($fecha_e);
	if (!$valid) {
		$datos = array('msg' => 'Fecha de envio invalida','status' => false ,'code' => 400);
		return $datos;
	}
	if (empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_array($listas) || count($listas) < 1) {
		$datos = array('msg' => 'Lista no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($listas as $value) {
		$valid=$per1->query_lists($value);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Lista no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($status) && $status == "3") {
		$datos = array('msg' => 'Status invalido','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per->check_status($status);
	if (!$valid) {
		$datos = array('msg' => 'Status invalido','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_campaign($id);
		if (!$valid) {
			$datos = array('msg' => 'Campaña no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id);
	if (!$valid) {
		$datos = array('msg' => '¡Error! Nombre existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}
/**
* Consulta de campañas.
*
*Funcion para consultar campañas registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_campaigns(){
	$per=new campaigns_model();
	$decryp=new routehelper();
	$datos=$per->query_campaigns(NULL);
	foreach ($datos as &$value) {
		$datos2=$per->check_lists_campaigns($value['id'],2);
		$value['listas']=(count($datos2) == 0) ? [] : $datos2;
		$act=$value['id'];
		$act=$decryp->encryptroute($act);
		$value['id']=$act;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar camapña.
*
*Funcion para Registrar camapña, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_campaign(){
	$per=new campaigns_model();
	$name=$_POST['name'];
	$asunto=$_POST['asunto'];
	$fecha_e=$_POST['fecha_e'];
	$status=$_POST['status'];
	$descripcion=$_POST['descripcion'];
	$listas=$_POST['listas'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_campaign($name,$asunto,$fecha_e,$descripcion,$listas,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_campaign($name,$asunto,$fecha_e,$descripcion,$listas,$status,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de campaigns.
*
*Funcion para consultar campaigns registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns
*/
public function view_campaign(){
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_model();
	$datos=$per->query_campaigns($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists_campaigns($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'listas' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Vista de campaigns.
*
*Funcion para consultar campaigns registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns
*/
public function dateils_campaign(){
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_model();
	$datos=$per->dateils_campaign($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists_campaigns($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'listas' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar campaigns.
*
*Funcion para Registrar camapña, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_campaign(){
	$per=new campaigns_model();
	$id=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($id);
	$option=explode('/',trim($option));
	$id=$option[1];
	$name=$_POST['name'];
	$asunto=$_POST['asunto'];
	$fecha_e=$_POST['fecha_e'];
	$status=$_POST['status'];
	$descripcion=$_POST['descripcion'];
	$listas=$_POST['listas'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_campaign($name,$asunto,$fecha_e,$descripcion,$listas,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$listas_s1=$per->check_lists_campaigns($id,1);
		$listas_s1=(count($listas_s1) == 0)? [] : $listas_s1;
		$agregar_s = array_diff($listas, $listas_s1);
		$eliminar_s = array_diff($listas_s1,$listas);

		$datos=$per->edit_campaign($agregar_s,$eliminar_s,$name,$asunto,$fecha_e,$descripcion,$status,$listas,$user,$id);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}
/**
* Duplicar de campaigns.
*
*Funcion para consultar campaigns registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns
*/
public function duplicate_campaign(){
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_model();
	$user=$_SESSION['bn_user_global'];
	$datos=$per->query_campaigns($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists_campaigns($var1,2);
		$datos=$per->duplicate_campaign($datos,$datos2,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}else{
		$datos1 = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Aprobar de campaigns.
*
*Funcion para consultar campaigns registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns
*/
public function approve_campaign(){
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_model();
	$user=$_SESSION['bn_user_global'];
	$datos=$per->query_campaigns($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_lists_campaigns($var1,1);
		$datos=$per->approve_campaign($datos,$datos2,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}else{
		$datos1 = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Elimimar camapña.
*
*Funcion para eliminar camapña, chequea si el camapña existe si arroja true elimina el camapña*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_campaign(){
	$per=new campaigns_model();
	$id=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($id);
	$option=explode('/',trim($option));
	$id=$option[1];
	$valid=$per->check_campaign($id);
	if (!$valid) {
		$datos = array('msg' => 'Campaña no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_campaign($id);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
/**
* Vista de campaigns.
*
*Funcion para consultar campaigns registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns
*/
public function lists_subscriber(){
	$var1=$_POST['id'];
	$lista=$_POST['lista'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_model();
	$datos=$per->lists_subscriber($var1,$lista);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'No Posee suscriptores Recibidos','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Vista de campaigns.
*
*Funcion para consultar campaigns registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $id id de campaigns
*/
public function lists_subscriber_no(){
	$var1=$_POST['id'];
	$lista=$_POST['lista'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new campaigns_model();
	$datos=$per->lists_subscriber_no($var1,$lista);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Camapña no posee suscriptores no recibido','status' => false,'code' => 400);
	}
	return $datos1;
}

}
?>