<?php
//Llamada al modelo
require 'model/blogs_model.php';

class blogs_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_blog($name,$categorias,$etiquetas,$descripcion,$imagen,$alt_imagen,$status,$id){
	$per=new blogs_model();
	if (strlen($name) > 150 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 150 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($alt_imagen) > 100 || empty($alt_imagen)) {
		$datos = array('msg' => 'Alt imagen no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_array($categorias) || count($categorias) < 1) {
		$datos = array('msg' => 'Categoria no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($categorias as $value) {
		$valid=$per->query_categories($value);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Categoria no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_array($etiquetas) || count($etiquetas) < 1) {
		$datos = array('msg' => 'Etiqueta no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($etiquetas as $value) {
		$valid=$per->query_tags($value);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Etiqueta no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($imagen)) {
		$ext = pathinfo($imagen['name'], PATHINFO_EXTENSION);
		if ($ext!=="png" && $ext!=="jpg" && $ext!=="jpeg") {
			$datos = array('msg' => 'Error formato de imagen.','status' => false ,'code' => 400);
			return $datos;
		}
		$tamaño = getimagesize($imagen['tmp_name']);
		if ($tamaño[0]> 3000 || $tamaño[1] > 3000 || $imagen['size'] > 500000) {		
			$datos = array('msg' =>'Error, la imagen debe tener un ancho inferior a 3000px y una altura de 3000px.','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_blog($id);
		if (!$valid) {
			$datos = array('msg' => 'Blog no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id);
	if (!$valid) {
		$datos = array('msg' => '¡Error! Nombre existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de blogs.
*
*Funcion para consultar blogs registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_blogs(){
	$per=new blogs_model();
	$datos=$per->query_blogs(NULL);
	foreach ($datos as &$value) {
	$datos2=$per->check_categories($value['id'],2);
	$value['categorias']=(count($datos2) == 0) ? [] : $datos2;
	$datos3=$per->check_tags($value['id'],2);
	$value['etiquetas']=(count($datos3) == 0) ? [] : $datos3;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de categoria.
*
*Funcion para consultar categoria registrados *
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_categories(){
	$per=new blogs_model();
	$datos=$per->query_categories(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de operadora.
*
*Funcion para consultar operadora registrados *
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_tags(){
	$per=new blogs_model();
	$datos=$per->query_tags(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_blog(){
	$per=new blogs_model();
	$name=$_POST['name'];
	$categorias=$_POST['categorias'];
	$etiquetas=$_POST['etiquetas'];
	$descripcion=$_POST['descripcion'];
	$imagen=$_FILES['imagen'];
	$alt_imagen=$_POST['alt_imagen'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_blog($name,$categorias,$etiquetas,$descripcion,$imagen,$alt_imagen,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_blog($name,$categorias,$etiquetas,$descripcion,$imagen,$alt_imagen,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de blogs.
*
*Funcion para consultar blogs registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de blogs
*/
public function view_blog(){
	$var1=$_POST['id'];
	$per=new blogs_model();
	$datos=$per->query_blogs($var1);
	if (count($datos) > 0) {
	$datos2=$per->check_categories($var1,2);
	$datos3=$per->check_tags($var1,2);
	$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'categorias' => $datos2,'etiquetas' => $datos3,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Blog no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Detalle de blogs.
*
*Funcion para consultar blogs registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de blogs
*/
public function details_blogs(){
	$var1=$_POST['id'];
	$per=new blogs_model();
	$datos=$per->details_blogs($var1);
	if (count($datos) > 0) {
	$datos2=$per->check_categories($var1,2);
	$datos3=$per->check_tags($var1,2);
	$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'categorias' => $datos2,'etiquetas' => $datos3,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Blog no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar blogs.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_blog(){
	$per=new blogs_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$categorias=$_POST['categorias'];
	$etiquetas=$_POST['etiquetas'];
	$descripcion=$_POST['descripcion'];
	$imagen=$_FILES['imagen'];
	$alt_imagen=$_POST['alt_imagen'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_blog($name,$categorias,$etiquetas,$descripcion,$imagen,$alt_imagen,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$categorias_s1=$per->check_categories($id,1);
		$categorias_s1=(count($categorias_s1) == 0)? [] : $categorias_s1;
		$agregar_s = array_diff($categorias, $categorias_s1);
		$eliminar_s = array_diff($categorias_s1,$categorias);
		$etiquetas_p1=$per->check_tags($id,1);
		$etiquetas_p1=(count($etiquetas_p1) == 0)? [] : $etiquetas_p1;
		$agregar_p = array_diff($etiquetas, $etiquetas_p1);
		$eliminar_p = array_diff($etiquetas_p1,$etiquetas);

		$datos=$per->edit_blog($name,$agregar_s,$eliminar_s,$agregar_p,$eliminar_p,$descripcion,$imagen,$alt_imagen,$status,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_blog(){
	$per=new blogs_model();
	$data1=$_POST['id'];
	$valid=$per->check_blog($data1);
	if (!$valid) {
		$datos = array('msg' => 'Blog no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_blog($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

}
?>