<?php
//Llamada al modelo
require 'model/agencies_model.php';

class agencies_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_agencie($name,$tlf,$productos,$comision,$email_a,$status,$perfil,$id,$id_reference,$name_reference,$comision_fee){
	$per=new agencies_model();
	if ($perfil != 4 && $perfil != 3) {
		$datos = array('msg' => 'Error perfil invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($name) > 100 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($tlf) > 50 || empty($tlf)) {
		$datos = array('msg' => 'tlf no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($email_a, FILTER_VALIDATE_EMAIL)) {
		$datos = array('msg' => 'Email invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_array($productos) || count($productos) < 1) {
		$datos = array('msg' => 'Producto no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	$user=$_SESSION['bn_user_global_agencias'];
	foreach ($productos as $value) {
		$valid=$per->select_products($value,$user);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Producto no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_array($comision) || count($comision) < 1) {
		$datos = array('msg' => 'Comision no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	if (count($comision) != count($productos)) {
		$datos = array('msg' => 'Items invalido ','status' => false ,'code' => 400);
		return $datos;
	}
	$x=0;
	foreach ($comision as $value) {
		//$value=int($value);
	    $value=str_replace('.','',$value);
	    $value=str_replace(',','.', $value);
		if (!filter_var($value, FILTER_VALIDATE_FLOAT) || $value < 1 || $value > 100) {
			$datos = array('msg' => 'Comision invalida','status' => false ,'code' => 400);
			return $datos;
		}
		$valid=$per->check_comision($productos[$x],$value,$user);
		if (!$valid) {
			$datos = array('msg' => 'Comision debe ser menor o igual a la asiganda al producto','status' => false ,'code' => 400);
			return $datos;
		}
		/*$valid=$per->check_comision_children($productos[$x],$value);
		if (!$valid) {
			$datos = array('msg' => 'Comision debe ser mayor a la asignada para los asesores','status' => false ,'code' => 400);
			return $datos;
		}*/
    $x++;
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($id)) {
		$valid=$per->check_agencie($id);
		if (!$valid) {
			$datos = array('msg' => 'Agencia no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($email_a,$id);
	if (!$valid) {
		$datos = array('msg' => '¡Error! Correo existe','status' => false ,'code' => 400);
		return $datos;
	}

	if (!empty($name_reference) || !empty($id_reference)) {
		if (strlen($id_reference) > 30 || empty($id_reference)) {
			$datos = array('msg' => 'Identificacion reference fee no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
			return $datos;
		}
		if (strlen($name_reference) > 100 || empty($name_reference)) {
			$datos = array('msg' => 'Nombres reference fee no debe estar vacío ni superar los 100 caracteres','status' => false ,'code' => 400);
			return $datos;
		}
		if (!filter_var($comision_fee, FILTER_VALIDATE_FLOAT) || $comision_fee < 1 || $comision_fee > 100) {
			$datos = array('msg' => 'Comision reference fee invalida','status' => false ,'code' => 400);
			return $datos;
		}
	}

	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de consulta 
* @param 
*/
public function query_agencies(){
	$per=new agencies_model();
	$datos=$per->query_agencies(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Generar token.
*
*Funcion para generar token para seccion de usuario*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function generation_body($correo,$clave){
	$encabezado='<center><div style="width:100%;"><img src="https://admin.bee-insurance.com/dist/img/logo2.png"  style="height: 60px;"></div><br><h1 style="color:#000">Bienvenido a Bee Insurance - Agencia</h1></center>';
	$body='<center><br><h3>Le damos la bienvenida a Bee Insurance estas son sus credenciales para el acceso al sistema</h3><p>Usuario:'.$correo.'</p><p>Clave:'.$clave.'</p><p><a href="https://admin.bee-insurance.com/login/">Click para ir al sistema</a></p></center>';

	$footer='<center><div style="text-align: center;">WhatsApp: <a href="https://api.whatsapp.com/send?phone=17867825313" > +17867825313 </a> | email: info@bee-insurance.com | web: www.bee-insurance.com</div></center>';  
	$html=$encabezado.$body.'<hr>'.$footer;

	return $html;
}
/**
* Generar token.
*
*Funcion para generar token para seccion de usuario*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function generation_pass(){
	$length = 10;
	$llave=substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length); 

	return $llave;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_agencie(){
	$per=new agencies_model();
	$name=$_POST['name'];
	$tlf=$_POST['tlf'];
	$productos=$_POST['productos'];
	$comision=$_POST['comision'];
	$email_a=$_POST['email_a'];
	$status=1;
	$user=$_SESSION['bn_user_global_agencias'];
	$perfil=$_SESSION['bn_perfil'];
	if ($perfil == "3") {
	$id_reference=$_POST['id_reference'];
	$name_reference=$_POST['name_reference'];
	$comision_fee=$_POST['comision_fee'];
    }else{
	$id_reference="";
	$name_reference="";
	$comision_fee="0.00";	
    }
	$valid=$this->validate_agencie($name,$tlf,$productos,$comision,$email_a,$status,$perfil,NULL,$id_reference,$name_reference,$comision_fee);
	if (!$valid['status']) {
		return $valid;
	}else{
		$clave=$this->generation_pass();
		$opciones = [
		'cost' => 12,
		];
		$clave_encrypt=password_hash($clave, PASSWORD_BCRYPT, $opciones);
	//Generaion html send mail//
		$body_mail=$this->generation_body($email_a,$clave);
		$datos=$per->register_agencie($name,$tlf,$productos,$comision,$email_a,$user,$clave_encrypt,$body_mail,$id_reference,$name_reference,$comision_fee);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos['status']) ? $resp2 : $resp1;
		if (!$datos['status'] && $datos['code'] == '1') {
		$resp2=array('msg' => 'Agencia registrada exitosamente Error al enviar el correo','status' => false,'code' => 400);
		return $resp2;
		}
		return $return;

	}
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de consulta 
* @param Method POST Int $var1 id de empleados
*/
public function view_agencie(){
	$var1=$_POST['id'];
	$per=new agencies_model();
	$datos=$per->query_agencies($var1);
	if (count($datos) > 0) {
	    $datos2=$per->query_comision(2,$var1);

		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'productos' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Agencia no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de consulta 
* @param Method POST Int $var1 id de empleados
*/
public function details_agencie(){
	$var1=$_POST['id'];
	$per=new agencies_model();
	$datos=$per->query_comision(2,$var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Agencia no posee productos agregados','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar empleados.
*
*Funcion para Registrar empleado, primero se envia a depurar informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_agencie(){
	$per=new agencies_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$tlf=$_POST['tlf'];
	$productos=$_POST['productos'];
	$comision=$_POST['comision'];
	$email_a=$_POST['email_a'];
	$user=$_SESSION['bn_user_global_agencias'];
	$perfil=$_SESSION['bn_perfil'];
	if ($perfil == "3") {
	$id_reference=$_POST['id_reference'];
	$name_reference=$_POST['name_reference'];
	$comision_fee=$_POST['comision_fee'];
    }else{
	$id_reference="";
	$name_reference="";
	$comision_fee="0.00";	
    }
	$valid=$this->validate_agencie($name,$tlf,$productos,$comision,$email_a,$status,$perfil,$id,$id_reference,$name_reference,$comision_fee);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_agencie($name,$tlf,$productos,$comision,$email_a,$status,$id,$user,$id_reference,$name_reference,$comision_fee);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_agencie(){
	$per=new agencies_model();
	$data1=$_POST['id'];
	$valid=$per->check_agencie($data1);
	if (!$valid) {
		$datos = array('msg' => 'Agencia no existe','status' => false,'code' => 400);
		return $datos;
	}
	/*$valid=$per->check_game($data1);
	if (!$valid) {
		$datos = array('msg' => 'Agencia tiene juegos asociados solo puede desactivar','status' => false,'code' => 400);
		return $datos;
	}*/
	$datos=$per->delete_agencie($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => 'Error Agencia posee datos asociados solo puede desactivar','status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
/**
* Consulta de productos.
*
*Funcion para consultar productos registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function select_products(){
	$user=$_SESSION['bn_user_global_agencias'];
	$per=new agencies_model();
	$datos=$per->select_products(NULL,$user);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
}
?>